/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.spring;

import java.io.File;
import java.lang.reflect.Method;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class SerializedFactoryBean
extends AbstractFactoryBean<Object> {
    private File _path;
    private Class<?> _objectType;
    private String _initMethod;

    public void setPath(File path) {
        this._path = path;
    }

    public void setObjectType(Class<?> objectType) {
        this._objectType = objectType;
    }

    public void setInitMethod(String initMethod) {
        this._initMethod = initMethod;
    }

    public Class<?> getObjectType() {
        return this._objectType;
    }

    protected Object createInstance() throws Exception {
        System.out.println("reading bean from file: " + this._path);
        Object obj = ObjectSerializationLibrary.readObject((File)this._path);
        if (this._initMethod != null) {
            Class<?> c = obj.getClass();
            for (Method method : c.getMethods()) {
                if (!method.getName().equals(this._initMethod)) continue;
                if (method.getParameterTypes().length > 0) {
                    System.err.println("cannot call init method " + this._initMethod + " on " + obj + " because method requires arguments");
                    continue;
                }
                method.invoke(obj, new Object[0]);
            }
        }
        System.out.println("  complete");
        return obj;
    }
}

