/**
 * Copyright (C) 2011 Brian Ferris <bdferris@onebusaway.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.onebusaway.container.cache;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * A method parameter annotation that is used to further control how method
 * cache keys are generated by the
 * {@link CacheableMethodManager#getKeyFactoryForParameterType(Class, boolean)}
 * 
 * 
 * @author bdferris
 * @see CacheableAnnotationInterceptor
 * @see CacheableMethodKeyFactory
 * @see CacheableMethodManager
 */
@Retention(value = RetentionPolicy.RUNTIME)
@Target(value = ElementType.PARAMETER)
public @interface CacheableArgument {

  /**
   * A bean property expression that is evaluated against the source method
   * argument to produce a cache key for that argument
   * 
   * @return a {@link Serializable} or something whose {@link Object#toString()}
   *         produces a unique value
   */
  String keyProperty() default "";

  boolean cacheRefreshIndicator() default false;
}
