/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.cache;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.onebusaway.collections.beans.PropertyPathExpression;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.container.cache.CacheableArgument;
import org.onebusaway.container.cache.CacheableKey;
import org.onebusaway.container.cache.CacheableMethodKeyFactory;
import org.onebusaway.container.cache.CacheableObjectKeyFactory;
import org.onebusaway.container.cache.DefaultCacheableKeyFactory;
import org.onebusaway.container.cache.DefaultCacheableObjectKeyFactory;
import org.onebusaway.container.cache.PropertyPathExpressionCacheableObjectKeyFactory;
import org.springframework.stereotype.Component;

@Component
public class CacheableMethodKeyFactoryManager {
    private Map<Class<?>, CacheableObjectKeyFactory> _keyFactories = new HashMap();
    private Map<Method, Integer> _cacheRefreshIndicatorArgumentIndexByMethod = new HashMap<Method, Integer>();

    public void addCacheableObjectKeyFactory(Class<?> className, CacheableObjectKeyFactory keyFactory) {
        this._keyFactories.put(className, keyFactory);
    }

    public void setCacheKeyFactories(Map<Object, Object> keyFactories) {
        for (Map.Entry<Object, Object> entry : keyFactories.entrySet()) {
            Class<?> className = this.getObjectAsClass(entry.getKey());
            CacheableObjectKeyFactory keyFactory = this.getObjectAsObjectKeyFactory(entry.getValue());
            this.addCacheableObjectKeyFactory(className, keyFactory);
        }
    }

    public void putCacheRefreshIndicatorArgumentIndexForMethodSignature(String methodName, int argumentIndex) {
        Method method = this.getMethodForSignature(methodName);
        this._cacheRefreshIndicatorArgumentIndexByMethod.put(method, argumentIndex);
    }

    public void putCacheRefreshIndicatorArgumentIndexForMethod(Method method, int argumentIndex) {
        this._cacheRefreshIndicatorArgumentIndexByMethod.put(method, argumentIndex);
    }

    public CacheableMethodKeyFactory getCacheableMethodKeyFactoryForJoinPoint(ProceedingJoinPoint pjp, Method method) {
        return this.getCacheableMethodKeyFactoryForMethod(method);
    }

    public CacheableMethodKeyFactory getCacheableMethodKeyFactoryForMethod(Method m) {
        Class<? extends CacheableMethodKeyFactory> keyFactoryType;
        Cacheable cacheableAnnotation = m.getAnnotation(Cacheable.class);
        if (cacheableAnnotation != null && !(keyFactoryType = cacheableAnnotation.keyFactory()).equals(CacheableMethodKeyFactory.class)) {
            try {
                return keyFactoryType.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalStateException("error instantiating CacheableKeyFactory: " + keyFactoryType.getName(), ex);
            }
        }
        Class<?>[] parameters = m.getParameterTypes();
        Annotation[][] annotations = m.getParameterAnnotations();
        int cacheRefreshParameterIndex = -1;
        if (this._cacheRefreshIndicatorArgumentIndexByMethod.containsKey(m)) {
            cacheRefreshParameterIndex = this._cacheRefreshIndicatorArgumentIndexByMethod.get(m);
        }
        CacheableObjectKeyFactory[] keyFactories = new CacheableObjectKeyFactory[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            boolean cacheRefreshIndicator = i == cacheRefreshParameterIndex;
            CacheableArgument cacheableArgumentAnnotation = this.getCacheableArgumentAnnotation(annotations[i]);
            keyFactories[i] = cacheableArgumentAnnotation != null ? this.getKeyFactoryForCacheableArgumentAnnotation(parameters[i], cacheableArgumentAnnotation, cacheRefreshIndicator) : this.getKeyFactoryForParameterType(parameters[i], cacheRefreshIndicator);
        }
        return new DefaultCacheableKeyFactory(keyFactories);
    }

    public Method getMatchingMethodForJoinPoint(ProceedingJoinPoint pjp) {
        List<Method> methods = this.getMatchingMethodsForJoinPoint(pjp);
        if (methods.size() == 1) {
            return methods.get(0);
        }
        if (methods.size() == 0) {
            throw new IllegalArgumentException("method not found: pjp=" + pjp.getSignature());
        }
        throw new IllegalArgumentException("multiple methods found: pjp=" + pjp.getSignature());
    }

    public List<Method> getMatchingMethodsForJoinPoint(ProceedingJoinPoint pjp) {
        Signature sig = pjp.getSignature();
        Object target = pjp.getTarget();
        Class<?> type = target.getClass();
        ArrayList<Method> matches = new ArrayList<Method>();
        for (Method m : type.getDeclaredMethods()) {
            Class<?>[] types;
            Object[] args;
            if (!m.getName().equals(sig.getName()) || (args = pjp.getArgs()).length != (types = m.getParameterTypes()).length) continue;
            boolean miss = false;
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Class<?> argType = types[i];
                if (argType.isPrimitive()) {
                    if (!argType.equals(Double.TYPE) || arg.getClass().equals(Double.class)) continue;
                    miss = true;
                    continue;
                }
                if (arg == null || argType.isInstance(arg)) continue;
                miss = true;
            }
            if (miss) continue;
            matches.add(m);
        }
        return matches;
    }

    protected CacheableArgument getCacheableArgumentAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof CacheableArgument)) continue;
            return (CacheableArgument)annotation;
        }
        return null;
    }

    protected CacheableObjectKeyFactory getKeyFactoryForCacheableArgumentAnnotation(Class<?> type, CacheableArgument cacheableArgumentAnnotation, boolean cacheRefreshIndicator) {
        String keyProperty = cacheableArgumentAnnotation.keyProperty();
        cacheRefreshIndicator |= cacheableArgumentAnnotation.cacheRefreshIndicator();
        if (keyProperty != null && !keyProperty.equals("")) {
            PropertyPathExpression expression = new PropertyPathExpression(keyProperty);
            type = expression.initialize(type);
            CacheableObjectKeyFactory factory = this.getKeyFactoryForParameterType(type, cacheRefreshIndicator);
            return new PropertyPathExpressionCacheableObjectKeyFactory(expression, factory);
        }
        return this.getKeyFactoryForParameterType(type, cacheRefreshIndicator);
    }

    protected CacheableObjectKeyFactory getKeyFactoryForParameterType(Class<?> type, boolean cacheRefreshIndicator) {
        if (this._keyFactories.containsKey(type)) {
            return this._keyFactories.get(type);
        }
        for (Map.Entry<Class<?>, CacheableObjectKeyFactory> entry : this._keyFactories.entrySet()) {
            Class<?> argumentType = entry.getKey();
            if (!argumentType.isAssignableFrom(type)) continue;
            return entry.getValue();
        }
        Class<?> checkType = type;
        while (checkType != null && !checkType.equals(Object.class)) {
            CacheableKey annotation = checkType.getAnnotation(CacheableKey.class);
            if (annotation != null) {
                Class<? extends CacheableObjectKeyFactory> keyFactoryType = annotation.keyFactory();
                try {
                    return keyFactoryType.newInstance();
                }
                catch (Exception ex) {
                    throw new IllegalStateException("error instantiating CacheableObjectKeyFactory [type=" + keyFactoryType.getName() + "] from CacheableKey [type=" + checkType.getName() + "]", ex);
                }
            }
            checkType = type.getSuperclass();
        }
        DefaultCacheableObjectKeyFactory factory = new DefaultCacheableObjectKeyFactory();
        factory.setCacheRefreshCheck(cacheRefreshIndicator);
        return factory;
    }

    protected Cache createCache(ProceedingJoinPoint pjp, String name) {
        return null;
    }

    private Class<?> getObjectAsClass(Object object) {
        if (object instanceof Class) {
            return (Class)object;
        }
        if (object instanceof String) {
            try {
                return Class.forName((String)object);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("unable to convert object to class: " + object);
    }

    private CacheableObjectKeyFactory getObjectAsObjectKeyFactory(Object value) {
        if (value instanceof CacheableObjectKeyFactory) {
            return (CacheableObjectKeyFactory)value;
        }
        Class<?> classType = this.getObjectAsClass(value);
        if (!CacheableObjectKeyFactory.class.isAssignableFrom(classType)) {
            throw new IllegalArgumentException(classType + " is not assignable to " + CacheableObjectKeyFactory.class);
        }
        try {
            return (CacheableObjectKeyFactory)classType.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalStateException("error instantiating " + classType, ex);
        }
    }

    private Method getMethodForSignature(String methodSignature) {
        int index = methodSignature.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException("invalid method signature: expected=package.ClassName.methodName actual=" + methodSignature);
        }
        String className = methodSignature.substring(0, index);
        String methodName = methodSignature.substring(index + 1);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            methods.add(method);
        }
        if (methods.size() == 1) {
            return (Method)methods.get(0);
        }
        if (methods.size() == 0) {
            throw new IllegalArgumentException("no method found for signature: " + methodSignature);
        }
        throw new IllegalArgumentException("multiple methods found for signature: " + methodSignature);
    }
}

