/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.spring;

import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.beans.factory.support.AbstractBeanDefinition;

public class DependencyConfigurer
extends PropertyResourceConfigurer {
    private static Logger _log = LoggerFactory.getLogger(DependencyConfigurer.class);
    private boolean _ignoreInvalidKeys = false;

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            try {
                this.processKey(beanFactory, key, props.getProperty(key));
            }
            catch (BeansException ex) {
                String msg = "Could not process key '" + key + "' in PropertyOverrideConfigurer";
                if (!this._ignoreInvalidKeys) {
                    throw new BeanInitializationException(msg, (Throwable)ex);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)msg, (Throwable)ex);
            }
        }
    }

    protected void processKey(ConfigurableListableBeanFactory beanFactory, String beanName, String property) {
        BeanDefinition bd = beanFactory.getBeanDefinition(beanName);
        if (bd instanceof AbstractBeanDefinition) {
            String[] beanNames;
            AbstractBeanDefinition abd = (AbstractBeanDefinition)bd;
            LinkedHashSet<String> dependsOn = new LinkedHashSet<String>();
            String[] existingDependencies = abd.getDependsOn();
            if (existingDependencies != null) {
                for (String name : existingDependencies) {
                    dependsOn.add(name);
                }
            }
            for (String name : beanNames = property.split(",")) {
                dependsOn.add(name);
            }
            abd.setDependsOn(dependsOn.toArray(new String[dependsOn.size()]));
        } else {
            _log.warn("bean definition for \"" + beanName + "\" does not extend AbstractBeanDefinition, so we can't set depends-on");
        }
    }
}

