/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.spring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;

public class OverridePostProcessor
implements BeanPostProcessor,
PriorityOrdered,
BeanFactoryAware {
    private Map<String, List<PropertyEntry>> _propertyEntriesByBeanName = new HashMap<String, List<PropertyEntry>>();
    private int _order = 0x7FFFFFFD;
    private BeanFactory _beanFactory;

    public void setMap(Map<String, String> map) {
        this.processMap(map);
    }

    public void setOrder(int order) {
        this._order = order;
    }

    public int getOrder() {
        return this._order;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this._beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        List<PropertyEntry> entries = this._propertyEntriesByBeanName.get(beanName);
        if (entries != null) {
            for (PropertyEntry entry : entries) {
                BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
                Object value = this._beanFactory.getBean(entry.value);
                if (value == null) {
                    throw new IllegalStateException("could not find bean with name: " + entry.value);
                }
                wrapper.setPropertyValue(entry.propertyName, value);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void processMap(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            int index = key.indexOf(46);
            if (index == -1) {
                throw new IllegalArgumentException("expected map key of form \"beanName.propertyName\" for " + key);
            }
            String beanName = key.substring(0, index);
            String propertyName = key.substring(index + 1);
            List<PropertyEntry> entries = this._propertyEntriesByBeanName.get(beanName);
            if (entries == null) {
                entries = new ArrayList<PropertyEntry>();
                this._propertyEntriesByBeanName.put(beanName, entries);
            }
            entries.add(new PropertyEntry(propertyName, entry.getValue()));
        }
    }

    private static class PropertyEntry {
        private String propertyName;
        private String value;

        public PropertyEntry(String propertyName, String value) {
            this.propertyName = propertyName;
            this.value = value;
        }
    }
}

