/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.spring;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class PropertyOverrideConfigurer
extends org.springframework.beans.factory.config.PropertyOverrideConfigurer {
    private static Logger _log = LoggerFactory.getLogger(PropertyOverrideConfigurer.class);
    private static final Pattern _pattern = Pattern.compile("\\$\\{([^}]+)\\}");
    private boolean ignoreInvalidBeans = false;

    public void setIgnoreInvalidBeans(boolean ignoreInvalidBeans) {
        this.ignoreInvalidBeans = ignoreInvalidBeans;
    }

    protected void applyPropertyValue(ConfigurableListableBeanFactory factory, String beanName, String property, String value) {
        if (value != null) {
            value = this.resolveValue(value);
        }
        if (!factory.containsBeanDefinition(beanName) && this.ignoreInvalidBeans) {
            return;
        }
        super.applyPropertyValue(factory, beanName, property, value);
    }

    protected String resolveValue(String value) {
        Matcher m = _pattern.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String property = m.group(1);
            Object propertyValue = System.getProperty(property);
            if (propertyValue == null) {
                _log.warn("no such System property: " + property);
                propertyValue = "${" + property + "}";
            } else {
                propertyValue = this.resolveValue((String)propertyValue);
            }
            propertyValue = Matcher.quoteReplacement((String)propertyValue);
            try {
                m.appendReplacement(sb, (String)propertyValue);
            }
            catch (Throwable ex) {
                _log.warn("error appending replacement: propertyName=" + property + " propertyValue=" + (String)propertyValue, ex);
            }
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

