/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.spring.ehcache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class EhCacheConfigurationFactoryBean
implements FactoryBean<Configuration>,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private Configuration configuration;
    private String diskStorePath;
    private String terracottaUrl;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setDiskStorePath(File diskStorePath) {
        this.diskStorePath = diskStorePath.getPath();
    }

    public void setTerracottaUrl(String terracottaUrl) {
        this.terracottaUrl = terracottaUrl;
    }

    public void afterPropertiesSet() throws IOException, CacheException {
        this.logger.info((Object)"Initializing EHCache CacheManager");
        this.configuration = ConfigurationFactory.parseConfiguration((InputStream)this.configLocation.getInputStream());
        if (this.diskStorePath != null) {
            this.logger.info((Object)("diskStorePath=" + this.diskStorePath));
            DiskStoreConfiguration dsConfig = new DiskStoreConfiguration();
            dsConfig.setPath(this.diskStorePath);
            this.logger.info((Object)("diskStorePath (translated)=" + dsConfig.getPath()));
            this.configuration.addDiskStore(dsConfig);
        }
        if (this.terracottaUrl != null) {
            this.logger.info((Object)("terracottaUrl=" + this.terracottaUrl));
            TerracottaClientConfiguration tcConfig = new TerracottaClientConfiguration();
            tcConfig.setUrl(this.terracottaUrl);
            this.configuration.addTerracottaConfig(tcConfig);
        }
    }

    public Configuration getObject() {
        return this.configuration;
    }

    public Class<?> getObjectType() {
        return this.configuration != null ? this.configuration.getClass() : Configuration.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

