/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.container.spring.ehcache;

import java.io.IOException;
import java.io.InputStream;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class EhCacheManagerFactoryBean
implements FactoryBean<CacheManager>,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private Configuration configuration;
    private String cacheManagerName;
    private CacheManager cacheManager;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setCacheManagerName(String cacheManagerName) {
        this.cacheManagerName = cacheManagerName;
    }

    public void afterPropertiesSet() throws IOException, CacheException {
        this.logger.info((Object)"Initializing EHCache CacheManager");
        Configuration config = this.configuration != null ? this.configuration : (this.configLocation != null ? ConfigurationFactory.parseConfiguration((InputStream)this.configLocation.getInputStream()) : new Configuration());
        if (this.cacheManagerName != null) {
            config.setName(this.cacheManagerName);
        }
        this.cacheManager = new CacheManager(config);
        if (!this.cacheManager.isNamed()) {
            this.logger.error((Object)"cacheManager is not named, this may cause problems.  Please set cacheManagerName in your spring configuration");
        }
    }

    public CacheManager getObject() {
        return this.cacheManager;
    }

    public Class<?> getObjectType() {
        return this.cacheManager != null ? this.cacheManager.getClass() : CacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info((Object)"Shutting down EHCache CacheManager");
        this.cacheManager.shutdown();
    }
}

