/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.utility;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateLibrary {
    public static String getTimeAsIso8601String(Date date) {
        return DateLibrary.getTimeAsIso8601String(date, TimeZone.getDefault());
    }

    public static String getTimeAsIso8601String(Date date, TimeZone timeZone) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        format.setTimeZone(timeZone);
        String timeString = format.format(date);
        return timeString.substring(0, timeString.length() - 2) + ":" + timeString.substring(timeString.length() - 2);
    }

    public static Date getIso8601StringAsTime(String value) throws ParseException {
        return DateLibrary.getIso8601StringAsTime(value, TimeZone.getDefault());
    }

    public static Date getIso8601StringAsTime(String value, TimeZone timeZone) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        format.setTimeZone(timeZone);
        int n = ((String)value).length();
        if (n > 6) {
            char c1 = ((String)value).charAt(n - 6);
            char c2 = ((String)value).charAt(n - 3);
            if ((c1 == '-' || c1 == '+') && c2 == ':') {
                value = ((String)value).substring(0, n - 3) + ((String)value).substring(n - 2);
            }
        }
        return format.parse((String)value);
    }

    public static Date getTimeAsDay(Date t) {
        return DateLibrary.getTimeAsDay(t.getTime());
    }

    public static Date getTimeAsDay(long t) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(t);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static boolean hasAmPmClock(Locale locale) {
        DateFormat stdFormat = DateFormat.getTimeInstance(3, Locale.US);
        DateFormat localeFormat = DateFormat.getTimeInstance(1, locale);
        String midnight = "";
        try {
            midnight = localeFormat.format(stdFormat.parse("12:00 AM"));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return midnight.contains("12");
    }
}

