/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.utility;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.onebusaway.utility.IOLibrary;

public class ObjectSerializationLibrary {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        for (int i = 0; i < args.length; ++i) {
            System.out.println((String)ObjectSerializationLibrary.readObject(new File(args[i])));
        }
    }

    public static ObjectOutputStream getFileAsObjectOutputStream(File file) throws IOException {
        OutputStream out = IOLibrary.getFileAsOutputStream(file);
        return new ObjectOutputStream(new BufferedOutputStream(out));
    }

    public static ObjectInputStream getFileAsObjectInputStream(File file) throws IOException {
        InputStream in = IOLibrary.getFileAsInputStream(file);
        return new ObjectInputStream(new BufferedInputStream(in));
    }

    public static void writeObject(File file, Object o) throws IOException {
        ObjectOutputStream oos = ObjectSerializationLibrary.getFileAsObjectOutputStream(file);
        oos.writeObject(o);
        oos.close();
    }

    public static <T> T readObject(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = ObjectSerializationLibrary.getFileAsObjectInputStream(file);
        Object o = ois.readObject();
        ois.close();
        return (T)o;
    }

    public static void printObject(File file, Object o) throws IOException {
        PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        out.println(o);
        out.close();
    }
}

