/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.utility;

import java.util.Arrays;
import org.onebusaway.utility.EInRangeStrategy;
import org.onebusaway.utility.EOutOfRangeStrategy;
import org.onebusaway.utility.InterpolationLibrary;

public class TransitInterpolationLibrary {
    private static final String OUT_OF_RANGE = "no values provided";

    public static Double interpolate(double[] keys, double[] values, double target, EOutOfRangeStrategy outOfRangeStrategy) {
        return TransitInterpolationLibrary.interpolate(keys, values, target, outOfRangeStrategy, null);
    }

    public static Double interpolate(double[] keys, double[] values, double target, EOutOfRangeStrategy outOfRangeStrategy, EInRangeStrategy inRangeStrategy) {
        if (values.length == 0) {
            throw new IndexOutOfBoundsException(OUT_OF_RANGE);
        }
        int index = Arrays.binarySearch(keys, target);
        if (index >= 0) {
            return values[index];
        }
        if ((index = -(index + 1)) == values.length) {
            switch (outOfRangeStrategy) {
                case INTERPOLATE: {
                    if (values.length > 1) {
                        return InterpolationLibrary.interpolatePair(keys[index - 2], values[index - 2], keys[index - 1], values[index - 1], target);
                    }
                    return values[index - 1];
                }
                case LAST_VALUE: {
                    return values[index - 1];
                }
                case EXCEPTION: {
                    throw new IndexOutOfBoundsException(OUT_OF_RANGE);
                }
            }
        }
        if (index == 0) {
            switch (outOfRangeStrategy) {
                case INTERPOLATE: {
                    if (values.length > 1) {
                        return InterpolationLibrary.interpolatePair(keys[0], values[0], keys[1], values[1], target);
                    }
                    return values[0];
                }
                case LAST_VALUE: {
                    return null;
                }
                case EXCEPTION: {
                    throw new IndexOutOfBoundsException(OUT_OF_RANGE);
                }
            }
        }
        if (inRangeStrategy == null) {
            inRangeStrategy = EInRangeStrategy.INTERPOLATE;
        }
        switch (inRangeStrategy) {
            case PREVIOUS_VALUE: {
                return values[index - 1];
            }
        }
        return InterpolationLibrary.interpolatePair(keys[index - 1], values[index - 1], keys[index], values[index], target);
    }
}

