/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.utility.filter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.onebusaway.utility.filter.IFilter;

public class FilteredIterator<T>
implements Iterator<T> {
    private Iterator<T> _sourceIt;
    private IFilter<T> _filter;
    private T _next;

    public FilteredIterator(Iterator<T> sourceIt, IFilter<T> filter) {
        this._sourceIt = sourceIt;
        this._filter = filter;
        this._next = this.getNext();
    }

    @Override
    public boolean hasNext() {
        return this._next != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T next = this._next;
        this._next = this.getNext();
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private T getNext() {
        while (this._sourceIt.hasNext()) {
            T obj = this._sourceIt.next();
            if (!this._filter.isEnabled(obj)) continue;
            return obj;
        }
        return null;
    }
}

