/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.king_county_metro;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.onebusaway.gtfs.csv.CsvEntityContext;
import org.onebusaway.gtfs.csv.schema.AbstractFieldMapping;
import org.onebusaway.gtfs.csv.schema.BeanWrapper;
import org.onebusaway.gtfs.csv.schema.EntitySchemaFactory;
import org.onebusaway.gtfs.csv.schema.FieldMapping;
import org.onebusaway.gtfs.csv.schema.FieldMappingFactory;

public class MetroKCDateFieldMappingFactory
implements FieldMappingFactory {
    private static DateFormat _format = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");

    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        return new FieldMappingImpl(entityType, csvFieldName, objFieldName, required);
    }

    private class FieldMappingImpl
    extends AbstractFieldMapping {
        public FieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, boolean required) {
            super(entityType, csvFieldName, objFieldName, required);
        }

        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            if (this.isMissingAndOptional(csvValues)) {
                return;
            }
            Object value = csvValues.get(this._csvFieldName);
            try {
                Date date = _format.parse(value.toString());
                object.setPropertyValue(this._objFieldName, (Object)date);
            }
            catch (ParseException ex) {
                throw new IllegalStateException("error parsing date: " + value, ex);
            }
        }

        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            Date date = (Date)object.getPropertyValue(this._objFieldName);
            csvValues.put(this._csvFieldName, _format.format(date));
        }
    }
}

