/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.onebusaway.gtfs.csv.schema.BeanWrapper;
import org.onebusaway.gtfs.csv.schema.BeanWrapperFactory;
import org.onebusaway.gtfs_transformer.GtfsTransformer;
import org.onebusaway.gtfs_transformer.impl.MatchingEntityModificationStrategyWrapper;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityUpdateStrategy;
import org.onebusaway.gtfs_transformer.impl.SimpleModificationStrategy;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.ModificationStrategy;
import org.onebusaway.gtfs_transformer.updates.EntityMatch;
import org.onebusaway.gtfs_transformer.updates.ModificationUpdateStrategy;

public class ModificationUpdateFactory {
    private ModificationUpdateStrategy _strategy = null;

    public void addModificationsFromFile(GtfsTransformer updater, File path) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(path));
        this.addModificationsFromReader(updater, reader);
    }

    public void addModificationsFromString(GtfsTransformer updater, String value) throws IOException {
        this.addModificationsFromReader(updater, new BufferedReader(new StringReader(value)));
    }

    public void addModificationsFromUrl(GtfsTransformer updater, URL url) throws IOException {
        InputStream in = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        this.addModificationsFromReader(updater, reader);
    }

    public void addModificationsFromReader(GtfsTransformer updater, BufferedReader reader) throws IOException {
        if (this._strategy == null) {
            this._strategy = new ModificationUpdateStrategy();
            updater.addTransform(this._strategy);
        }
        String line = null;
        while ((line = reader.readLine()) != null) {
            try {
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.equals("{{{") || line.equals("}}}")) continue;
                JSONObject json = new JSONObject(line);
                String opType = json.getString("op");
                if (opType == null) {
                    throw new IllegalStateException("must specify an \"op\" argument: line=" + line);
                }
                if (opType.equals("add")) {
                    this.handleAddOperation(line, json);
                    continue;
                }
                if (opType.equals("update") || opType.equals("change") || opType.equals("modify")) {
                    this.handleUpdateOperation(line, json);
                    continue;
                }
                if (opType.equals("remove") || opType.equals("delete")) {
                    this.handleRemoveOperation(line, json);
                    continue;
                }
                if (opType.equals("retain")) {
                    this.handleRetainOperation(line, json);
                    continue;
                }
                if (!opType.equals("transform")) continue;
                this.handleTransformOperation(line, json);
            }
            catch (JSONException ex) {
                throw new IllegalStateException("error parsing json for line=" + line, ex);
            }
        }
    }

    private void handleAddOperation(String line, JSONObject json) throws JSONException {
        JSONObject properties = json.getJSONObject("obj");
        Map<String, Object> here = this.getEntityPropertiesAndValuesFromJsonObject(properties);
        Class<?> entityClass = this.getEntityTypeForName(properties.getString("class"));
        Object instance = this.instantiate(entityClass);
        BeanWrapper wrapper = BeanWrapperFactory.wrap((Object)instance);
        for (Map.Entry<String, Object> entry : here.entrySet()) {
            wrapper.setPropertyValue(entry.getKey(), entry.getValue());
        }
        this._strategy.addEntity(instance);
    }

    private void handleUpdateOperation(String line, JSONObject json) throws JSONException {
        EntityMatch match = this.getMatch(line, json);
        if (json.has("factory")) {
            String value = json.getString("factory");
            try {
                Class<?> clazz = Class.forName(value);
                Object factoryObj = clazz.newInstance();
                if (!(factoryObj instanceof ModificationStrategy)) {
                    throw new IllegalArgumentException("factory object is not an instance of ModificationStrategy: " + clazz.getName());
                }
                this._strategy.addModification(match.getType(), new MatchingEntityModificationStrategyWrapper(match.getPropertyMatches(), (ModificationStrategy)factoryObj));
            }
            catch (Throwable ex) {
                throw new IllegalStateException("error creating factory ModificationStrategy instance", ex);
            }
            return;
        }
        if (!json.has("update")) {
            throw new IllegalArgumentException("modification must have \"update\" argument: line=" + line);
        }
        JSONObject update = json.getJSONObject("update");
        Map<String, Object> propertyUpdates = this.getEntityPropertiesAndValuesFromJsonObject(update);
        SimpleModificationStrategy mod = new SimpleModificationStrategy(match.getPropertyMatches(), propertyUpdates);
        this._strategy.addModification(match.getType(), mod);
    }

    private void handleRemoveOperation(String line, JSONObject json) throws JSONException {
        EntityMatch match = this.getMatch(line, json);
        RemoveEntityUpdateStrategy mod = new RemoveEntityUpdateStrategy(match.getPropertyMatches());
        this._strategy.addRemoval(match.getType(), mod);
    }

    private void handleRetainOperation(String line, JSONObject json) throws JSONException {
        EntityMatch match = this.getMatch(line, json);
        this._strategy.addRetention(match);
    }

    private void handleTransformOperation(String line, JSONObject json) throws JSONException {
        if (!json.has("class")) {
            throw new IllegalArgumentException("transform does not specify a class: " + line);
        }
        String value = json.getString("class");
        try {
            Class<?> clazz = Class.forName(value);
            Object factoryObj = clazz.newInstance();
            if (!(factoryObj instanceof GtfsTransformStrategy)) {
                throw new IllegalArgumentException("factory object is not an instance of GtfsTransformStrategy: " + clazz.getName());
            }
            BeanWrapper wrapped = BeanWrapperFactory.wrap(factoryObj);
            Iterator it = json.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (key.equals("op") || key.equals("class")) continue;
                Object v = json.get(key);
                wrapped.setPropertyValue(key, v);
            }
            this._strategy.addTransform((GtfsTransformStrategy)factoryObj);
        }
        catch (Exception ex) {
            throw new IllegalStateException("error instantiating class: " + value, ex);
        }
    }

    private Class<?> getEntityTypeForName(String name) {
        Class<?> type = this.getClassForName(name);
        if (type == null) {
            type = this.getClassForName("org.onebusaway.gtfs.model." + name);
        }
        if (type == null) {
            type = this.getClassForName("org.onebusaway.gtfs_transformer.king_county_metro.model." + name);
        }
        if (type == null) {
            throw new IllegalArgumentException("class not found: " + name);
        }
        return type;
    }

    private Class<?> getClassForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private EntityMatch getMatch(String line, JSONObject json) throws JSONException {
        JSONObject match = json.getJSONObject("match");
        if (match == null) {
            throw new IllegalArgumentException("modification must have \"match\" argument: line=" + line);
        }
        String entityTypeString = match.getString("class");
        if (entityTypeString == null) {
            throw new IllegalArgumentException("modification match must have \"class\" argument: line=" + line);
        }
        Class<?> entityType = this.getEntityTypeForName(entityTypeString);
        Map<String, Object> propertyMatches = this.getEntityPropertiesAndValuesFromJsonObject(match);
        return new EntityMatch(entityType, propertyMatches);
    }

    private Map<String, Object> getEntityPropertiesAndValuesFromJsonObject(JSONObject obj) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator it = obj.keys();
        while (it.hasNext()) {
            String property = (String)it.next();
            Object value = obj.get(property);
            if (property.equals("class")) continue;
            map.put(property, value);
        }
        return map;
    }

    private Object instantiate(Class<?> entityClass) {
        try {
            return entityClass.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalStateException("error instantiating type: " + entityClass.getName());
        }
    }
}

