/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.csv.schema.BeanWrapper;
import org.onebusaway.gtfs.csv.schema.BeanWrapperFactory;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.serialization.GtfsEntitySchemaFactory;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.ModificationStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.EntityMatch;
import org.onebusaway.gtfs_transformer.updates.EntityRetentionGraph;

public class ModificationUpdateStrategy
implements GtfsTransformStrategy {
    private List<Object> _objectsToAdd = new ArrayList<Object>();
    private Map<Class<?>, List<ModificationStrategy>> _modificationsByType = new HashMap();
    private Map<Class<?>, List<ModificationStrategy>> _removalsByType = new HashMap();
    private Map<Class<?>, List<EntityMatch>> _retentionMatchesByType = new HashMap();
    private List<GtfsTransformStrategy> _transforms = new ArrayList<GtfsTransformStrategy>();

    public void addEntity(Object object) {
        this._objectsToAdd.add(object);
    }

    public void addModification(Class<?> type, ModificationStrategy modification) {
        List<ModificationStrategy> modifications = this.getModificationsForType(type, this._modificationsByType);
        modifications.add(modification);
    }

    public void addRemoval(Class<?> type, ModificationStrategy modification) {
        List<ModificationStrategy> modifications = this.getModificationsForType(type, this._removalsByType);
        modifications.add(modification);
    }

    public void addRetention(EntityMatch match) {
        List<EntityMatch> matches = this._retentionMatchesByType.get(match.getType());
        if (matches == null) {
            matches = new ArrayList<EntityMatch>();
            this._retentionMatchesByType.put(match.getType(), matches);
        }
        matches.add(match);
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        for (Object entity : this._objectsToAdd) {
            dao.saveEntity(entity);
        }
        this.applyModifications(context, dao, this._modificationsByType);
        this.applyModifications(context, dao, this._removalsByType);
        for (GtfsTransformStrategy transform : this._transforms) {
            transform.run(context, dao);
        }
        this.applyRetentions(dao);
    }

    private void applyModifications(TransformContext context, GtfsMutableRelationalDao dao, Map<Class<?>, List<ModificationStrategy>> modificationsByType) {
        for (Map.Entry<Class<?>, List<ModificationStrategy>> entry : this._modificationsByType.entrySet()) {
            Class<?> entityType = entry.getKey();
            List<ModificationStrategy> modifications = entry.getValue();
            ArrayList entities = new ArrayList(dao.getAllEntitiesForType(entityType));
            for (Object object : entities) {
                BeanWrapper wrapper = BeanWrapperFactory.wrap(object);
                for (ModificationStrategy modification : modifications) {
                    modification.applyModification(context, wrapper, dao);
                }
            }
        }
    }

    private void applyRetentions(GtfsMutableRelationalDao dao) {
        if (this._retentionMatchesByType.isEmpty()) {
            return;
        }
        EntityRetentionGraph graph = new EntityRetentionGraph((GtfsRelationalDao)dao);
        for (Map.Entry<Class<?>, List<EntityMatch>> entry : this._retentionMatchesByType.entrySet()) {
            Class<?> entityType = entry.getKey();
            List<EntityMatch> matches = entry.getValue();
            ArrayList entities = new ArrayList(dao.getAllEntitiesForType(entityType));
            for (Object object : entities) {
                BeanWrapper wrapper = BeanWrapperFactory.wrap(object);
                for (EntityMatch match : matches) {
                    if (!match.isApplicableToObject(wrapper)) continue;
                    graph.retain(object);
                }
            }
        }
        for (Class entityClass : GtfsEntitySchemaFactory.getEntityClasses()) {
            ArrayList objectsToRemove = new ArrayList();
            for (Object entity : dao.getAllEntitiesForType(entityClass)) {
                if (graph.isRetained(entity)) continue;
                objectsToRemove.add(entity);
            }
            for (Object toRemove : objectsToRemove) {
                dao.removeEntity((IdentityBean)toRemove);
            }
        }
    }

    private List<ModificationStrategy> getModificationsForType(Class<?> type, Map<Class<?>, List<ModificationStrategy>> m) {
        List<ModificationStrategy> modifications = m.get(type);
        if (modifications == null) {
            modifications = new ArrayList<ModificationStrategy>();
            m.put(type, modifications);
        }
        return modifications;
    }

    public void addTransform(GtfsTransformStrategy strategy) {
        this._transforms.add(strategy);
    }
}

