/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.king_county_metro.transforms.UpdateLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveDuplicateTripsStrategy
implements GtfsTransformStrategy {
    private Logger _log = LoggerFactory.getLogger(RemoveDuplicateTripsStrategy.class);

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        FactoryMap tripsByPattern = new FactoryMap(new ArrayList());
        for (Trip trip : dao.getAllTrips()) {
            Pattern pattern = this.getPatternForTrip(dao, trip);
            ((List)tripsByPattern.get(pattern)).add(trip);
        }
        int duplicateTrips = 0;
        for (List trips : tripsByPattern.values()) {
            if (trips.size() == 1) continue;
            for (int i = 1; i < trips.size(); ++i) {
                Trip trip = (Trip)trips.get(i);
                List stopTimes = dao.getStopTimesForTrip(trip);
                for (StopTime stopTime : stopTimes) {
                    dao.removeEntity((IdentityBean)stopTime);
                }
                dao.removeEntity((IdentityBean)trip);
                ++duplicateTrips;
            }
        }
        UpdateLibrary.clearDaoCache(dao);
        this._log.info("removed " + duplicateTrips + " duplicate trips");
    }

    private Pattern getPatternForTrip(GtfsMutableRelationalDao dao, Trip trip) {
        List stopTimes = dao.getStopTimesForTrip(trip);
        int n = stopTimes.size();
        AgencyAndId[] stopIds = new AgencyAndId[n];
        int[] arrivalTimes = new int[n];
        int[] departureTimes = new int[n];
        for (int i = 0; i < n; ++i) {
            StopTime stopTime = (StopTime)stopTimes.get(i);
            stopIds[i] = stopTime.getStop().getId();
            arrivalTimes[i] = stopTime.getArrivalTime();
            departureTimes[i] = stopTime.getDepartureTime();
        }
        return new Pattern(trip.getRoute().getId(), trip.getServiceId(), stopIds, arrivalTimes, departureTimes);
    }

    private static class Pattern {
        private AgencyAndId _routeId;
        private AgencyAndId _serviceId;
        private final AgencyAndId[] _stopIds;
        private final int[] _arrivalTimes;
        private final int[] _departureTimes;

        public Pattern(AgencyAndId routeId, AgencyAndId serviceId, AgencyAndId[] stopIds, int[] arrivalTimes, int[] departureTimes) {
            this._routeId = routeId;
            this._serviceId = serviceId;
            this._stopIds = stopIds;
            this._arrivalTimes = arrivalTimes;
            this._departureTimes = departureTimes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this._arrivalTimes);
            result = 31 * result + Arrays.hashCode(this._departureTimes);
            result = 31 * result + (this._routeId == null ? 0 : this._routeId.hashCode());
            result = 31 * result + (this._serviceId == null ? 0 : this._serviceId.hashCode());
            result = 31 * result + Arrays.hashCode(this._stopIds);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pattern other = (Pattern)obj;
            if (!Arrays.equals(this._arrivalTimes, other._arrivalTimes)) {
                return false;
            }
            if (!Arrays.equals(this._departureTimes, other._departureTimes)) {
                return false;
            }
            if (this._routeId == null ? other._routeId != null : !this._routeId.equals((Object)other._routeId)) {
                return false;
            }
            if (this._serviceId == null ? other._serviceId != null : !this._serviceId.equals((Object)other._serviceId)) {
                return false;
            }
            return Arrays.equals(this._stopIds, other._stopIds);
        }
    }
}

