/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.csv.schema.BeanWrapper;
import org.onebusaway.gtfs.csv.schema.BeanWrapperFactory;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.serialization.GtfsEntitySchemaFactory;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_transformer.factory.EntityMatch;
import org.onebusaway.gtfs_transformer.factory.EntityRetentionGraph;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class RetainEntitiesTransformStrategy
implements GtfsTransformStrategy {
    private Map<Class<?>, List<EntityMatch>> _retentionMatchesByType = new HashMap();

    public void addRetention(EntityMatch match) {
        List<EntityMatch> matches = this._retentionMatchesByType.get(match.getType());
        if (matches == null) {
            matches = new ArrayList<EntityMatch>();
            this._retentionMatchesByType.put(match.getType(), matches);
        }
        matches.add(match);
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        if (this._retentionMatchesByType.isEmpty()) {
            return;
        }
        EntityRetentionGraph graph = new EntityRetentionGraph((GtfsRelationalDao)dao);
        for (Map.Entry<Class<?>, List<EntityMatch>> entry : this._retentionMatchesByType.entrySet()) {
            Class<?> entityType = entry.getKey();
            List<EntityMatch> matches = entry.getValue();
            ArrayList entities = new ArrayList(dao.getAllEntitiesForType(entityType));
            for (Object object : entities) {
                BeanWrapper wrapper = BeanWrapperFactory.wrap(object);
                for (EntityMatch match : matches) {
                    if (!match.isApplicableToObject(wrapper)) continue;
                    graph.retain(object);
                }
            }
        }
        for (Class entityClass : GtfsEntitySchemaFactory.getEntityClasses()) {
            ArrayList objectsToRemove = new ArrayList();
            for (Object entity : dao.getAllEntitiesForType(entityClass)) {
                if (graph.isRetained(entity)) continue;
                objectsToRemove.add(entity);
            }
            for (Object toRemove : objectsToRemove) {
                dao.removeEntity((IdentityBean)toRemove);
            }
        }
    }
}

