/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.king_county_metro.transforms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.collections.tuple.Pair;
import org.onebusaway.collections.tuple.Tuples;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.king_county_metro.model.PatternPair;
import org.onebusaway.gtfs_transformer.king_county_metro.transforms.UpdateLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.TripsByBlockInSortedOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternPairUpdateStrategy
implements GtfsTransformStrategy {
    private static Logger _log = LoggerFactory.getLogger(PatternPairUpdateStrategy.class);
    private Map<Trip, List<StopTime>> _stopTimesByTrip = new HashMap<Trip, List<StopTime>>();
    private Map<Pair<String>, Set<String>> _stopIdsByRoutePair = new HashMap<Pair<String>, Set<String>>();
    private Map<AgencyAndId, List<ShapePoint>> _shapePointsByShapeId = new HashMap<AgencyAndId, List<ShapePoint>>();
    private Set<AgencyAndId> _updateShapePointIds = new HashSet<AgencyAndId>();
    private int _maxShapePointIndex = 0;
    private GtfsMutableRelationalDao _dao;

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        this.reset();
        this._dao = dao;
        this.addPatterPairsToCache();
        this.addStopTimesToCache();
        this.addShapePointsToCache();
        Map<String, List<Trip>> tripsByBlockId = TripsByBlockInSortedOrder.getTripsByBlockInSortedOrder(dao);
        for (List<Trip> trips : tripsByBlockId.values()) {
            Trip prev = null;
            boolean prevModified = false;
            for (Trip trip : trips) {
                boolean modified = false;
                if (prev != null && !prevModified) {
                    EPairUpdateResult result = this.checkTripPair(prev, trip);
                    modified = result == EPairUpdateResult.MODIFIED;
                }
                prev = trip;
                prevModified = modified;
            }
        }
        this.reset();
        UpdateLibrary.clearDaoCache(dao);
    }

    private void reset() {
        this._stopIdsByRoutePair.clear();
        this._stopTimesByTrip.clear();
    }

    private List<ShapePoint> getShapePointsForShapeId(AgencyAndId shapeId) {
        return this._shapePointsByShapeId.get(shapeId);
    }

    private boolean hasUpdatedShapePointsForId(AgencyAndId shapeId) {
        return this._updateShapePointIds.contains(shapeId);
    }

    private void setUpdatedShapePointsForId(AgencyAndId shapeId) {
        this._updateShapePointIds.add(shapeId);
    }

    private void setStopTimesForTrip(Trip trip, List<StopTime> stopTimes) {
        this._stopTimesByTrip.put(trip, stopTimes);
    }

    private List<StopTime> getStopTimesForTrip(Trip trip) {
        return this._stopTimesByTrip.get(trip);
    }

    private void addStopIdForRoutePair(Pair<String> routePair, String stopId) {
        Set<String> stopIds = this._stopIdsByRoutePair.get(routePair);
        if (stopIds == null) {
            stopIds = new HashSet<String>();
            this._stopIdsByRoutePair.put(routePair, stopIds);
        }
        stopIds.add(stopId);
    }

    private Set<String> getStopIdForRoutePair(Pair<String> routePair) {
        Set<String> stopIds = this._stopIdsByRoutePair.get(routePair);
        if (stopIds == null) {
            stopIds = Collections.emptySet();
        }
        return stopIds;
    }

    private void addPatterPairsToCache() {
        Collection patternPairs = this._dao.getAllEntitiesForType(PatternPair.class);
        for (PatternPair patternPair : patternPairs) {
            if (patternPair.getRouteFrom().equals(patternPair.getRouteTo())) continue;
            String fromRoute = patternPair.getRouteFrom();
            String toRoute = patternPair.getRouteTo();
            Pair routePair = Tuples.pair((Object)fromRoute, (Object)toRoute);
            if (patternPair.getStopId() == null) continue;
            this.addStopIdForRoutePair((Pair<String>)routePair, patternPair.getStopId());
        }
    }

    private void addStopTimesToCache() {
        for (Trip trip : this._dao.getAllTrips()) {
            ArrayList<StopTime> stopTimes = this._dao.getStopTimesForTrip(trip);
            stopTimes = new ArrayList<StopTime>(stopTimes);
            Collections.sort(stopTimes);
            this.setStopTimesForTrip(trip, stopTimes);
        }
    }

    private void addShapePointsToCache() {
        for (ShapePoint shapePoint : this._dao.getAllShapePoints()) {
            AgencyAndId shapeId = shapePoint.getShapeId();
            List<ShapePoint> points = this._shapePointsByShapeId.get(shapeId);
            if (points == null) {
                points = new ArrayList<ShapePoint>();
                this._shapePointsByShapeId.put(shapeId, points);
            }
            points.add(shapePoint);
            this._maxShapePointIndex = Math.max(shapePoint.getId(), this._maxShapePointIndex);
        }
        for (List list : this._shapePointsByShapeId.values()) {
            Collections.sort(list);
        }
    }

    private EPairUpdateResult checkTripPair(Trip prev, Trip next) {
        List<StopTime> stopTimesPrev = this.getStopTimesForTrip(prev);
        List<StopTime> stopTimesNext = this.getStopTimesForTrip(next);
        if (stopTimesPrev.isEmpty()) {
            return EPairUpdateResult.UNMODIFIED;
        }
        if (stopTimesNext.isEmpty()) {
            return EPairUpdateResult.UNMODIFIED;
        }
        this.pruneSameOverlappingPrevAndNextStops(stopTimesPrev, stopTimesNext);
        if (this.getStopTimeSeparation(stopTimesPrev, stopTimesNext) > 300) {
            return EPairUpdateResult.UNMODIFIED;
        }
        String routeA = prev.getRoute().getShortName();
        String routeB = next.getRoute().getShortName();
        Pair pair = Tuples.pair((Object)routeA, (Object)routeB);
        Set<String> stopIds = this.getStopIdForRoutePair((Pair<String>)pair);
        for (String stopId : stopIds) {
            int indexPrev = this.indexOfTail(stopTimesPrev, stopId);
            int indexNext = this.indexOf(stopTimesNext, stopId);
            if (indexPrev == -1 && indexNext == -1) continue;
            if (indexPrev != -1 && indexNext != -1) {
                _log.warn("both trips contained stop in pattern pair: prev=" + prev.getId() + " next=" + next.getId() + " stop=" + stopId);
                return EPairUpdateResult.UNMODIFIED;
            }
            if (indexPrev != -1) {
                StopTime transitionStopTime = stopTimesPrev.get(indexPrev);
                Stop transitionStop = transitionStopTime.getStop();
                this.shiftFromPrevToNext(prev, stopTimesPrev, next, stopTimesNext, indexPrev);
                if (prev.getShapeId() != null && next.getShapeId() != null) {
                    String shapeKey = prev.getShapeId().getId() + "-" + next.getShapeId().getId();
                    this.shiftShapePointsFromPrevToNext(prev, next, transitionStop, shapeKey);
                }
                return EPairUpdateResult.MODIFIED;
            }
            if (indexNext == 0) {
                return EPairUpdateResult.UP_TO_DATE;
            }
            if (indexNext <= 0) continue;
            this.shiftFromNextToPrev(prev, stopTimesPrev, next, stopTimesNext, indexNext);
            return EPairUpdateResult.MODIFIED;
        }
        if (!stopIds.isEmpty()) {
            _log.warn("neither trip contained stop in pair: prev=" + prev.getId() + " next=" + next.getId() + " stop=" + stopIds);
        }
        return EPairUpdateResult.UNMODIFIED;
    }

    private void pruneSameOverlappingPrevAndNextStops(List<StopTime> stopTimesPrev, List<StopTime> stopTimesNext) {
        StopTime stopTimePrev = stopTimesPrev.get(stopTimesPrev.size() - 1);
        StopTime stopTimeNext = stopTimesNext.get(0);
        if (stopTimePrev.getStop().getId().equals((Object)stopTimeNext.getStop().getId())) {
            stopTimesPrev.remove(stopTimesPrev.size() - 1);
            this._dao.removeEntity((IdentityBean)stopTimePrev);
        }
    }

    private int indexOfTail(List<StopTime> stopTimes, String stopId) {
        for (int i = stopTimes.size() - 1; i >= 0; --i) {
            StopTime stopTime = stopTimes.get(i);
            if (!stopTime.getStop().getId().getId().equals(stopId)) continue;
            return i;
        }
        return -1;
    }

    private int indexOf(List<StopTime> stopTimes, String stopId) {
        int index = 0;
        for (StopTime stopTime : stopTimes) {
            if (stopTime.getStop().getId().getId().equals(stopId)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void shiftFromPrevToNext(Trip prev, List<StopTime> stopTimesPrev, Trip next, List<StopTime> stopTimesNext, int indexPrev) {
        StopTime first = stopTimesNext.get(0);
        int stopSequence = first.getStopSequence() - 1;
        for (int i = stopTimesPrev.size() - 1; i >= indexPrev; --i) {
            StopTime stopTime = stopTimesPrev.remove(i);
            stopTime.setTrip(next);
            stopTime.setStopSequence(stopSequence--);
            stopTimesNext.add(0, stopTime);
        }
    }

    private void shiftShapePointsFromPrevToNext(Trip prev, Trip next, Stop transitionStop, String key) {
        AgencyAndId shapeIdPrev = prev.getShapeId();
        AgencyAndId shapeIdNext = next.getShapeId();
        if (shapeIdPrev == null || shapeIdNext == null) {
            throw new IllegalStateException("we expected shapes for both trips");
        }
        AgencyAndId modShapeIdPrev = new AgencyAndId(shapeIdPrev.getAgencyId(), shapeIdPrev.getId() + "-" + key);
        AgencyAndId modShapeIdNext = new AgencyAndId(shapeIdNext.getAgencyId(), shapeIdNext.getId() + "-" + key);
        boolean a = this.hasUpdatedShapePointsForId(modShapeIdPrev);
        boolean b = this.hasUpdatedShapePointsForId(modShapeIdNext);
        prev.setShapeId(modShapeIdPrev);
        next.setShapeId(modShapeIdNext);
        if (a && b) {
            return;
        }
        if (a ^ b) {
            throw new IllegalStateException("how did we update one and not the other?");
        }
        List<ShapePoint> shapePointsPrev = this.getShapePointsForShapeId(shapeIdPrev);
        List<ShapePoint> shapePointsNext = this.getShapePointsForShapeId(shapeIdNext);
        if (shapePointsPrev == null || shapePointsPrev.isEmpty() || shapePointsNext == null || shapePointsNext.isEmpty()) {
            throw new IllegalStateException("no shape points for shapeIds? prev=" + shapeIdPrev + " next=" + shapeIdNext);
        }
        List<ShapePoint> shapePointsModPrev = this.copyShapePointsWithNewShapeId(shapePointsPrev, modShapeIdPrev);
        List<ShapePoint> shapePointsModNext = this.copyShapePointsWithNewShapeId(shapePointsNext, modShapeIdNext);
        int closestPointIndex = this.getClosestPointIndex(shapePointsModPrev, transitionStop);
        for (int i = shapePointsModPrev.size() - 1; i >= closestPointIndex; --i) {
            ShapePoint shapePoint = shapePointsModPrev.remove(i);
            shapePoint.setShapeId(modShapeIdNext);
            shapePointsModNext.add(0, shapePoint);
        }
        this.resetShapePointSequence(shapePointsModPrev);
        this.resetShapePointSequence(shapePointsModNext);
        this.setUpdatedShapePointsForId(modShapeIdPrev);
        this.setUpdatedShapePointsForId(modShapeIdNext);
        for (ShapePoint point : shapePointsModPrev) {
            this._dao.saveEntity((Object)point);
        }
        for (ShapePoint point : shapePointsModNext) {
            this._dao.saveEntity((Object)point);
        }
    }

    private void shiftFromNextToPrev(Trip prev, List<StopTime> stopTimesPrev, Trip next, List<StopTime> stopTimesNext, int indexNext) {
        System.out.println("here: " + indexNext);
        StopTime last = stopTimesPrev.get(stopTimesPrev.size() - 1);
        int stopSequence = last.getStopSequence() + 1;
        for (int i = 0; i <= indexNext; ++i) {
            StopTime stopTime = stopTimesNext.remove(i);
            stopTime.setTrip(prev);
            stopTime.setStopSequence(stopSequence++);
            stopTimesPrev.add(stopTime);
        }
    }

    private List<ShapePoint> copyShapePointsWithNewShapeId(List<ShapePoint> shapePoints, AgencyAndId shapeId) {
        ArrayList<ShapePoint> updatedPoints = new ArrayList<ShapePoint>();
        for (ShapePoint point : shapePoints) {
            ShapePoint updatedPoint = new ShapePoint(point);
            updatedPoint.setId(Integer.valueOf(++this._maxShapePointIndex));
            updatedPoint.setShapeId(shapeId);
            updatedPoints.add(updatedPoint);
        }
        return updatedPoints;
    }

    private int getClosestPointIndex(List<ShapePoint> shapePoints, Stop stop) {
        int minIndex = -1;
        double minDistance = Double.POSITIVE_INFINITY;
        int index = 0;
        for (ShapePoint shapePoint : shapePoints) {
            double distance = PatternPairUpdateStrategy.distance(shapePoint.getLat(), shapePoint.getLon(), stop.getLat(), stop.getLon());
            if (distance < minDistance) {
                minDistance = distance;
                minIndex = index;
            }
            ++index;
        }
        return minIndex;
    }

    private void resetShapePointSequence(List<ShapePoint> shapePoints) {
        int sequence = 0;
        for (ShapePoint shapePoint : shapePoints) {
            shapePoint.setSequence(sequence++);
        }
    }

    private int getStopTimeSeparation(List<StopTime> stopTimesA, List<StopTime> stopTimesB) {
        StopTime last = stopTimesA.get(stopTimesA.size() - 1);
        StopTime first = stopTimesB.get(0);
        return first.getArrivalTime() - last.getDepartureTime();
    }

    private static final double distance(double lat1, double lon1, double lat2, double lon2) {
        double radius = 6371010.0;
        lat1 = Math.toRadians(lat1);
        lon1 = Math.toRadians(lon1);
        lat2 = Math.toRadians(lat2);
        lon2 = Math.toRadians(lon2);
        double deltaLon = lon2 - lon1;
        double y = Math.sqrt(PatternPairUpdateStrategy.p2(Math.cos(lat2) * Math.sin(deltaLon)) + PatternPairUpdateStrategy.p2(Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(deltaLon)));
        double x = Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(deltaLon);
        return radius * Math.atan2(y, x);
    }

    private static final double p2(double v) {
        return v * v;
    }

    private static enum EPairUpdateResult {
        UNMODIFIED,
        MODIFIED,
        UP_TO_DATE;

    }
}

