/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.onebusaway.csv_entities.schema.DefaultEntitySchemaFactory;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.ListableCsvMappingFactory;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.serialization.GtfsEntitySchemaFactory;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsWriter;
import org.onebusaway.gtfs.services.GenericMutableDao;
import org.onebusaway.gtfs.services.GtfsDao;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.factory.TransformFactory;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.SchemaUpdateStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class GtfsTransformer {
    private File _gtfsInputDirectory;
    private File _outputDirectory;
    private List<GtfsTransformStrategy> _transformStrategies = new ArrayList<GtfsTransformStrategy>();
    private List<SchemaUpdateStrategy> _outputSchemaUpdates = new ArrayList<SchemaUpdateStrategy>();
    private GtfsReader _reader = new GtfsReader();
    private GtfsMutableRelationalDao _dao = new GtfsRelationalDaoImpl();
    private String _agencyId;
    private TransformFactory _transformFactory = new TransformFactory();

    public void setGtfsInputDirectory(File gtfsInputDirectory) {
        this._gtfsInputDirectory = gtfsInputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this._outputDirectory = outputDirectory;
    }

    public void addTransform(GtfsTransformStrategy strategy) {
        this._transformStrategies.add(strategy);
    }

    public List<GtfsTransformStrategy> getTransforms() {
        return this._transformStrategies;
    }

    public GtfsTransformStrategy getLastTransform() {
        if (this._transformStrategies.isEmpty()) {
            return null;
        }
        return this._transformStrategies.get(this._transformStrategies.size() - 1);
    }

    public void addOutputSchemaUpdate(SchemaUpdateStrategy outputSchemaUpdate) {
        this._outputSchemaUpdates.add(outputSchemaUpdate);
    }

    public void setAgencyId(String agencyId) {
        this._agencyId = agencyId;
    }

    public GtfsReader getReader() {
        return this._reader;
    }

    public TransformFactory getTransformFactory() {
        return this._transformFactory;
    }

    public void run() throws Exception {
        if (!this._outputDirectory.exists()) {
            this._outputDirectory.mkdirs();
        }
        System.out.println("Output Directory=" + this._outputDirectory);
        this.readGtfs();
        this.udateGtfs();
        this.writeGtfs();
    }

    private void readGtfs() throws IOException {
        this._reader.setInputLocation(this._gtfsInputDirectory);
        this._reader.setEntityStore((GenericMutableDao)this._dao);
        if (this._agencyId != null) {
            this._reader.setDefaultAgencyId(this._agencyId);
        }
        this._reader.run();
    }

    private void udateGtfs() {
        TransformContext context = new TransformContext();
        if (this._agencyId != null) {
            context.setDefaultAgencyId(this._agencyId);
        }
        for (GtfsTransformStrategy strategy : this._transformStrategies) {
            strategy.run(context, this._dao);
        }
    }

    private void writeGtfs() throws IOException {
        GtfsWriter writer = new GtfsWriter();
        writer.setOutputLocation(this._outputDirectory);
        DefaultEntitySchemaFactory schemaFactory = new DefaultEntitySchemaFactory();
        schemaFactory.addFactory((ListableCsvMappingFactory)GtfsEntitySchemaFactory.createEntitySchemaFactory());
        for (SchemaUpdateStrategy strategy : this._outputSchemaUpdates) {
            strategy.updateSchema(schemaFactory);
        }
        writer.setEntitySchemaFactory((EntitySchemaFactory)schemaFactory);
        writer.run((GtfsDao)this._dao);
    }
}

