/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.BeanWrapperFactory;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.serialization.GtfsEntitySchemaFactory;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_transformer.factory.EntityMatch;
import org.onebusaway.gtfs_transformer.factory.EntityRetentionGraph;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class RetainEntitiesTransformStrategy
implements GtfsTransformStrategy {
    private Map<Class<?>, List<EntityRetention>> _retentionMatchesByType = new HashMap();

    public void addRetention(EntityMatch match, boolean retainUp) {
        List<EntityRetention> matches = this._retentionMatchesByType.get(match.getType());
        if (matches == null) {
            matches = new ArrayList<EntityRetention>();
            this._retentionMatchesByType.put(match.getType(), matches);
        }
        EntityRetention retention = new EntityRetention(match, retainUp);
        matches.add(retention);
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        if (this._retentionMatchesByType.isEmpty()) {
            return;
        }
        EntityRetentionGraph graph = new EntityRetentionGraph((GtfsRelationalDao)dao);
        for (Map.Entry<Class<?>, List<EntityRetention>> entry : this._retentionMatchesByType.entrySet()) {
            Class<?> entityType = entry.getKey();
            List<EntityRetention> retentions = entry.getValue();
            ArrayList entities = new ArrayList(dao.getAllEntitiesForType(entityType));
            for (Object object : entities) {
                BeanWrapper wrapper = BeanWrapperFactory.wrap(object);
                for (EntityRetention retention : retentions) {
                    EntityMatch match = retention.getMatch();
                    if (!match.isApplicableToObject(wrapper)) continue;
                    graph.retain(object, retention.isRetainUp());
                }
            }
        }
        for (Class entityClass : GtfsEntitySchemaFactory.getEntityClasses()) {
            ArrayList objectsToRemove = new ArrayList();
            for (Object entity : dao.getAllEntitiesForType(entityClass)) {
                if (graph.isRetained(entity)) continue;
                objectsToRemove.add(entity);
            }
            for (Object toRemove : objectsToRemove) {
                dao.removeEntity((IdentityBean)toRemove);
            }
        }
    }

    private static class EntityRetention {
        private final EntityMatch match;
        private final boolean retainUp;

        public EntityRetention(EntityMatch match, boolean retainUp) {
            this.match = match;
            this.retainUp = retainUp;
        }

        public EntityMatch getMatch() {
            return this.match;
        }

        public boolean isRetainUp() {
            return this.retainUp;
        }
    }
}

