/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.factory.PropertyMatches;
import org.onebusaway.gtfs_transformer.impl.AbstractEntityModificationStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class RemoveEntityUpdateStrategy
extends AbstractEntityModificationStrategy {
    public RemoveEntityUpdateStrategy(PropertyMatches propertyMatches) {
        super(propertyMatches);
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao, BeanWrapper entity) {
        if (!this.isModificationApplicable(entity)) {
            return;
        }
        Object obj = entity.getWrappedInstance(Object.class);
        if (obj instanceof Agency) {
            this.removeAgency(dao, (Agency)obj);
        } else if (obj instanceof Route) {
            this.removeRoute(dao, (Route)obj);
        } else if (obj instanceof Stop) {
            this.removeStop(dao, (Stop)obj);
        } else if (obj instanceof Trip) {
            this.removeTrip(dao, (Trip)obj);
        } else if (obj instanceof StopTime) {
            this.removeStopTime(dao, (StopTime)obj);
        }
    }

    private void removeAgency(GtfsMutableRelationalDao dao, Agency agency) {
        for (Route route : dao.getRoutesForAgency(agency)) {
            this.removeRoute(dao, route);
        }
        dao.removeEntity((IdentityBean)agency);
    }

    private void removeRoute(GtfsMutableRelationalDao dao, Route route) {
        for (Trip trip : dao.getTripsForRoute(route)) {
            this.removeTrip(dao, trip);
        }
        dao.removeEntity((IdentityBean)route);
    }

    private void removeTrip(GtfsMutableRelationalDao dao, Trip trip) {
        for (StopTime stopTime : dao.getStopTimesForTrip(trip)) {
            this.removeStopTime(dao, stopTime);
        }
        for (Frequency frequency : dao.getFrequenciesForTrip(trip)) {
            this.removeFrequency(dao, frequency);
        }
        dao.removeEntity((IdentityBean)trip);
    }

    private void removeFrequency(GtfsMutableRelationalDao dao, Frequency frequency) {
        dao.removeEntity((IdentityBean)frequency);
    }

    private void removeStop(GtfsMutableRelationalDao dao, Stop stop) {
        for (StopTime stopTime : dao.getStopTimesForStop(stop)) {
            this.removeStopTime(dao, stopTime);
        }
        dao.removeEntity((IdentityBean)stop);
    }

    private void removeStopTime(GtfsMutableRelationalDao dao, StopTime stopTime) {
        dao.removeEntity((IdentityBean)stopTime);
    }
}

