/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.onebusaway.csv_entities.schema.DefaultEntitySchemaFactory;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.ListableCsvMappingFactory;
import org.onebusaway.gtfs.impl.GenericMutableDaoWrapper;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.serialization.GtfsEntitySchemaFactory;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsWriter;
import org.onebusaway.gtfs.services.GenericMutableDao;
import org.onebusaway.gtfs.services.GtfsDao;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.factory.TransformFactory;
import org.onebusaway.gtfs_transformer.impl.converters.AgencyAndIdConverter;
import org.onebusaway.gtfs_transformer.services.GtfsEntityTransformStrategy;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.SchemaUpdateStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class GtfsTransformer {
    private File _gtfsInputDirectory;
    private File _outputDirectory;
    private List<GtfsTransformStrategy> _transformStrategies = new ArrayList<GtfsTransformStrategy>();
    private List<GtfsEntityTransformStrategy> _entityTransformStrategies = new ArrayList<GtfsEntityTransformStrategy>();
    private List<SchemaUpdateStrategy> _outputSchemaUpdates = new ArrayList<SchemaUpdateStrategy>();
    private TransformContext _context = new TransformContext();
    private GtfsReader _reader = new GtfsReader();
    private GtfsMutableRelationalDao _dao = new GtfsRelationalDaoImpl();
    private String _agencyId;
    private TransformFactory _transformFactory = new TransformFactory();

    public void setGtfsInputDirectory(File gtfsInputDirectory) {
        this._gtfsInputDirectory = gtfsInputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this._outputDirectory = outputDirectory;
    }

    public void addTransform(GtfsTransformStrategy strategy) {
        this._transformStrategies.add(strategy);
    }

    public List<GtfsTransformStrategy> getTransforms() {
        return this._transformStrategies;
    }

    public GtfsTransformStrategy getLastTransform() {
        if (this._transformStrategies.isEmpty()) {
            return null;
        }
        return this._transformStrategies.get(this._transformStrategies.size() - 1);
    }

    public void addEntityTransform(GtfsEntityTransformStrategy entityTransform) {
        this._entityTransformStrategies.add(entityTransform);
    }

    public void addOutputSchemaUpdate(SchemaUpdateStrategy outputSchemaUpdate) {
        this._outputSchemaUpdates.add(outputSchemaUpdate);
    }

    public void setAgencyId(String agencyId) {
        this._agencyId = agencyId;
    }

    public GtfsReader getReader() {
        return this._reader;
    }

    public TransformFactory getTransformFactory() {
        return this._transformFactory;
    }

    public void run() throws Exception {
        this.registerConverters();
        if (!this._outputDirectory.exists()) {
            this._outputDirectory.mkdirs();
        }
        System.out.println("Output Directory=" + this._outputDirectory);
        if (this._agencyId != null) {
            this._context.setDefaultAgencyId(this._agencyId);
        }
        this.readGtfs();
        this.udateGtfs();
        this.writeGtfs();
    }

    protected void registerConverters() {
        ConvertUtils.register((Converter)new AgencyAndIdConverter(), AgencyAndId.class);
    }

    private void readGtfs() throws IOException {
        Object dao = this._dao;
        if (!this._entityTransformStrategies.isEmpty()) {
            dao = new DaoInterceptor((GenericMutableDao)this._dao);
        }
        this._reader.setInputLocation(this._gtfsInputDirectory);
        this._reader.setEntityStore((GenericMutableDao)dao);
        if (this._agencyId != null) {
            this._reader.setDefaultAgencyId(this._agencyId);
        }
        this._reader.run();
    }

    private void udateGtfs() {
        for (GtfsTransformStrategy strategy : this._transformStrategies) {
            strategy.run(this._context, this._dao);
        }
    }

    private void writeGtfs() throws IOException {
        GtfsWriter writer = new GtfsWriter();
        writer.setOutputLocation(this._outputDirectory);
        DefaultEntitySchemaFactory schemaFactory = new DefaultEntitySchemaFactory();
        schemaFactory.addFactory((ListableCsvMappingFactory)GtfsEntitySchemaFactory.createEntitySchemaFactory());
        for (SchemaUpdateStrategy strategy : this._outputSchemaUpdates) {
            strategy.updateSchema(schemaFactory);
        }
        writer.setEntitySchemaFactory((EntitySchemaFactory)schemaFactory);
        writer.run((GtfsDao)this._dao);
    }

    private class DaoInterceptor
    extends GenericMutableDaoWrapper {
        public DaoInterceptor(GenericMutableDao source) {
            super(source);
        }

        public void saveEntity(Object entity) {
            for (GtfsEntityTransformStrategy strategy : GtfsTransformer.this._entityTransformStrategies) {
                entity = strategy.transformEntity(GtfsTransformer.this._context, GtfsTransformer.this._dao, entity);
                if (entity != null) continue;
                return;
            }
            super.saveEntity(entity);
        }
    }
}

