/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.factory;

import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.onebusaway.collections.PropertyPathExpression;
import org.onebusaway.csv_entities.schema.BeanWrapper;

public class PropertyMatches {
    private final Map<PropertyPathExpression, Object> _propertyMatches;

    public PropertyMatches(Map<PropertyPathExpression, Object> propertyMatches) {
        this._propertyMatches = propertyMatches;
    }

    public Map<PropertyPathExpression, Object> getPropertyMatches() {
        return this._propertyMatches;
    }

    public boolean isApplicableToObject(BeanWrapper wrapped) {
        for (Map.Entry<PropertyPathExpression, Object> entry : this._propertyMatches.entrySet()) {
            Object converted;
            Converter converter;
            boolean nullB;
            PropertyPathExpression expression = entry.getKey();
            Object expected = entry.getValue();
            Object actual = expression.invoke(wrapped.getWrappedInstance(Object.class));
            boolean nullA = expected == null;
            boolean bl = nullB = actual == null;
            if (nullA && nullB) {
                return true;
            }
            if (nullA ^ nullB) {
                return false;
            }
            Class<?> expectedType = expected.getClass();
            Class<?> actualType = actual.getClass();
            if (!actualType.isAssignableFrom(expectedType) && expectedType == String.class && (converter = ConvertUtils.lookup(actualType)) != null && (converted = converter.convert(actualType, expected)) != null) {
                expected = converted;
            }
            if ((expected != null || actual == null) && expected.equals(actual)) continue;
            return false;
        }
        return true;
    }
}

