/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.collections.IdKey;
import org.onebusaway.gtfs_transformer.collections.IdKeyMatch;
import org.onebusaway.gtfs_transformer.match.EntityMatch;
import org.onebusaway.gtfs_transformer.match.TypedEntityMatch;
import org.onebusaway.gtfs_transformer.services.EntityTransformStrategy;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class EntitiesTransformStrategy
implements GtfsTransformStrategy {
    private Map<Class<?>, List<MatchAndTransform>> _modificationsByType = new HashMap();

    public void addModification(TypedEntityMatch match, EntityTransformStrategy modification) {
        List<MatchAndTransform> modifications = this.getModificationsForType(match.getType(), this._modificationsByType);
        modifications.add(new MatchAndTransform(match.getPropertyMatches(), modification));
    }

    public List<MatchAndTransform> getTransformsForType(Class<?> entityType) {
        List<MatchAndTransform> transforms = this._modificationsByType.get(entityType);
        if (transforms == null) {
            return Collections.emptyList();
        }
        return transforms;
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        for (Map.Entry<Class<?>, List<MatchAndTransform>> entry : this._modificationsByType.entrySet()) {
            Class<?> entityType = entry.getKey();
            List<MatchAndTransform> modifications = entry.getValue();
            if (IdKey.class.isAssignableFrom(entityType)) {
                for (MatchAndTransform pair : modifications) {
                    IdKeyMatch match = (IdKeyMatch)pair.match;
                    pair.transform.run(context, dao, match.getKey());
                }
                continue;
            }
            ArrayList entities = new ArrayList(dao.getAllEntitiesForType(entityType));
            for (Object object : entities) {
                for (MatchAndTransform pair : modifications) {
                    if (!pair.match.isApplicableToObject(object)) continue;
                    pair.transform.run(context, dao, object);
                }
            }
        }
    }

    private List<MatchAndTransform> getModificationsForType(Class<?> type, Map<Class<?>, List<MatchAndTransform>> m) {
        List<MatchAndTransform> modifications = m.get(type);
        if (modifications == null) {
            modifications = new ArrayList<MatchAndTransform>();
            m.put(type, modifications);
        }
        return modifications;
    }

    public static class MatchAndTransform {
        private final EntityMatch match;
        private final EntityTransformStrategy transform;

        public MatchAndTransform(EntityMatch match, EntityTransformStrategy transform) {
            this.match = match;
            this.transform = transform;
        }

        public EntityMatch getMatch() {
            return this.match;
        }

        public EntityTransformStrategy getTransform() {
            return this.transform;
        }
    }
}

