/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.serialization.GtfsEntitySchemaFactory;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_transformer.collections.IdKey;
import org.onebusaway.gtfs_transformer.collections.IdKeyMatch;
import org.onebusaway.gtfs_transformer.factory.EntityRetentionGraph;
import org.onebusaway.gtfs_transformer.match.TypedEntityMatch;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class RetainEntitiesTransformStrategy
implements GtfsTransformStrategy {
    private Map<Class<?>, List<EntityRetention>> _retentionMatchesByType = new HashMap();
    private boolean _retainBlocks = true;

    public void setRetainBlocks(boolean retainBlocks) {
        this._retainBlocks = retainBlocks;
    }

    public void addRetention(TypedEntityMatch match, boolean retainUp) {
        List<EntityRetention> matches = this._retentionMatchesByType.get(match.getType());
        if (matches == null) {
            matches = new ArrayList<EntityRetention>();
            this._retentionMatchesByType.put(match.getType(), matches);
        }
        EntityRetention retention = new EntityRetention(match, retainUp);
        matches.add(retention);
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        if (this._retentionMatchesByType.isEmpty()) {
            return;
        }
        EntityRetentionGraph graph = new EntityRetentionGraph((GtfsRelationalDao)dao);
        graph.setRetainBlocks(this._retainBlocks);
        for (Map.Entry<Class<?>, List<EntityRetention>> entry : this._retentionMatchesByType.entrySet()) {
            Class<?> entityType = entry.getKey();
            List<EntityRetention> retentions = entry.getValue();
            if (IdKey.class.isAssignableFrom(entityType)) {
                for (EntityRetention retention : retentions) {
                    TypedEntityMatch typedMatch = retention.getMatch();
                    IdKeyMatch match = (IdKeyMatch)typedMatch.getPropertyMatches();
                    graph.retain(match.getKey(), retention.isRetainUp());
                }
                continue;
            }
            ArrayList entities = new ArrayList(dao.getAllEntitiesForType(entityType));
            for (Object object : entities) {
                for (EntityRetention retention : retentions) {
                    TypedEntityMatch match = retention.getMatch();
                    if (!match.isApplicableToObject(object)) continue;
                    graph.retain(object, retention.isRetainUp());
                }
            }
        }
        for (Class entityClass : GtfsEntitySchemaFactory.getEntityClasses()) {
            ArrayList objectsToRemove = new ArrayList();
            for (Object entity : dao.getAllEntitiesForType(entityClass)) {
                if (graph.isRetained(entity)) continue;
                objectsToRemove.add(entity);
            }
            for (Object toRemove : objectsToRemove) {
                dao.removeEntity((IdentityBean)toRemove);
            }
        }
    }

    private static class EntityRetention {
        private final TypedEntityMatch match;
        private final boolean retainUp;

        public EntityRetention(TypedEntityMatch match, boolean retainUp) {
            this.match = match;
            this.retainUp = retainUp;
        }

        public TypedEntityMatch getMatch() {
            return this.match;
        }

        public boolean isRetainUp() {
            return this.retainUp;
        }
    }
}

