/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.SingleFieldMapping;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;
import org.onebusaway.gtfs.serialization.mappings.ConverterFactory;
import org.onebusaway.gtfs_transformer.impl.EntitySchemaCache;

public class DeferredValueSupport {
    private final GtfsReader _reader;
    private final EntitySchemaCache _schemaCache;

    public DeferredValueSupport(GtfsReader reader, EntitySchemaCache schemaCache) {
        this._reader = reader;
        this._schemaCache = schemaCache;
    }

    public GtfsReader getReader() {
        return this._reader;
    }

    public Object resolveAgencyAndId(BeanWrapper bean, String propertyName, String stringValue) {
        GtfsReaderContext context = this._reader.getGtfsReaderContext();
        String agencyId = context.getDefaultAgencyId();
        AgencyAndId existingId = (AgencyAndId)bean.getPropertyValue(propertyName);
        if (existingId != null) {
            agencyId = existingId.getAgencyId();
        }
        return new AgencyAndId(agencyId, stringValue);
    }

    public Converter resolveConverter(Class<?> parentEntityType, String propertyName, Class<?> expectedValueType) {
        SingleFieldMapping mapping = this._schemaCache.getFieldMappingForCsvFieldName(parentEntityType, propertyName);
        if (mapping == null) {
            mapping = this._schemaCache.getFieldMappingForObjectFieldName(parentEntityType, propertyName);
        }
        if (mapping != null) {
            if (mapping instanceof ConverterFactory) {
                ConverterFactory factory = (ConverterFactory)mapping;
                return factory.create(this._reader.getContext());
            }
            if (mapping instanceof Converter) {
                return (Converter)mapping;
            }
        }
        return ConvertUtils.lookup(expectedValueType);
    }
}

