/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.HashMap;
import java.util.Map;
import org.onebusaway.csv_entities.schema.EntitySchema;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.SingleFieldMapping;
import org.onebusaway.gtfs.serialization.GtfsReader;

public class EntitySchemaCache {
    private Map<String, EntitySchema> _entitySchemasByFileName = new HashMap<String, EntitySchema>();
    private Map<Class<?>, EntitySchema> _entitySchemasByEntityType = new HashMap();
    private Map<Class<?>, Map<String, SingleFieldMapping>> _mappingsByTypeAndCsvFieldName = new HashMap();
    private Map<Class<?>, Map<String, SingleFieldMapping>> _mappingsByTypeAndObjectFieldName = new HashMap();

    public void addEntitySchemasFromGtfsReader(GtfsReader reader) {
        EntitySchemaFactory factory = reader.getEntitySchemaFactory();
        for (Class entityType : reader.getEntityClasses()) {
            EntitySchema schema = factory.getSchema(entityType);
            this.addEntitySchema(schema);
        }
    }

    public void addEntitySchema(EntitySchema schema) {
        this._entitySchemasByEntityType.put(schema.getEntityClass(), schema);
        if (schema.getFilename() != null) {
            this._entitySchemasByFileName.put(schema.getFilename(), schema);
        }
        for (FieldMapping mapping : schema.getFields()) {
            if (!(mapping instanceof SingleFieldMapping)) continue;
            SingleFieldMapping single = (SingleFieldMapping)mapping;
            EntitySchemaCache.putMappingForEntityTypeAndName(this._mappingsByTypeAndCsvFieldName, schema.getEntityClass(), single.getCsvFieldName(), single);
            EntitySchemaCache.putMappingForEntityTypeAndName(this._mappingsByTypeAndObjectFieldName, schema.getEntityClass(), single.getObjFieldName(), single);
        }
    }

    public SingleFieldMapping getFieldMappingForCsvFieldName(Class<?> entityType, String csvFieldName) {
        Map<String, SingleFieldMapping> mappings = this._mappingsByTypeAndCsvFieldName.get(entityType);
        if (mappings == null) {
            return null;
        }
        return mappings.get(csvFieldName);
    }

    public SingleFieldMapping getFieldMappingForObjectFieldName(Class<?> entityType, String objFieldName) {
        Map<String, SingleFieldMapping> mappings = this._mappingsByTypeAndObjectFieldName.get(entityType);
        if (mappings == null) {
            return null;
        }
        return mappings.get(objFieldName);
    }

    public EntitySchema getSchemaForFileName(String fileName) {
        return this._entitySchemasByFileName.get(fileName);
    }

    public EntitySchema getSchemaForEntityType(Class<?> entityType) {
        return this._entitySchemasByEntityType.get(entityType);
    }

    private static void putMappingForEntityTypeAndName(Map<Class<?>, Map<String, SingleFieldMapping>> mappingsByEntityType, Class<?> entityType, String name, SingleFieldMapping mapping) {
        Map<String, SingleFieldMapping> mappings = mappingsByEntityType.get(entityType);
        if (mappings == null) {
            mappings = new HashMap<String, SingleFieldMapping>();
            mappingsByEntityType.put(entityType, mappings);
        }
        mappings.put(name, mapping);
    }
}

