/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.Map;
import org.onebusaway.collections.tuple.Pair;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.BeanWrapperFactory;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.EntityTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class StringModificationStrategy
implements EntityTransformStrategy {
    private Map<String, Pair<String>> _propertyUpdates;

    public StringModificationStrategy(Map<String, Pair<String>> propertyUpdates) {
        this._propertyUpdates = propertyUpdates;
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao, Object entity) {
        BeanWrapper wrapper = BeanWrapperFactory.wrap((Object)entity);
        for (Map.Entry<String, Pair<String>> entry : this._propertyUpdates.entrySet()) {
            String property = entry.getKey();
            Pair<String> value = entry.getValue();
            Object propertyValue = wrapper.getPropertyValue(property);
            if (propertyValue == null) continue;
            String propertyStringValue = propertyValue.toString();
            propertyStringValue = propertyStringValue.replaceAll((String)value.getFirst(), (String)value.getSecond());
            wrapper.setPropertyValue(property, (Object)propertyStringValue);
        }
    }
}

