/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.List;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class LocalVsExpressUpdateStrategy
implements GtfsTransformStrategy {
    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        for (Route route : dao.getAllRoutes()) {
            List trips = dao.getTripsForRoute(route);
            if (trips.isEmpty()) continue;
            int localCount = 0;
            int expressCount = 0;
            for (Trip trip : trips) {
                boolean isExpress = trip.getTripShortName().equals("EXPRESS");
                if (isExpress) {
                    ++expressCount;
                    continue;
                }
                ++localCount;
            }
            boolean addLocalVsExpressToTripName = localCount > 0 && expressCount > 0;
            for (Trip trip : trips) {
                String tripHeadsign;
                boolean isExpress = trip.getTripShortName().equals("EXPRESS");
                if (!isExpress) continue;
                trip.setRouteShortName(trip.getRoute().getShortName() + "E");
                if (!addLocalVsExpressToTripName || (tripHeadsign = trip.getTripHeadsign()) == null) continue;
                trip.setTripHeadsign(tripHeadsign + " - Express");
            }
        }
    }
}

