/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.List;
import java.util.Map;
import org.onebusaway.collections.MappingLibrary;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveEmptyBlockTripsStrategy
implements GtfsTransformStrategy {
    private static Logger _log = LoggerFactory.getLogger(RemoveEmptyBlockTripsStrategy.class);

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        Map tripsByBlockId = MappingLibrary.mapToValueList((Iterable)dao.getAllTrips(), (String)"blockId", String.class);
        int tripsRemoved = 0;
        int blocksRemoved = 0;
        for (Map.Entry entry : tripsByBlockId.entrySet()) {
            String blockId = (String)entry.getKey();
            List trips = (List)entry.getValue();
            if (blockId == null) continue;
            boolean hasStopTimes = false;
            for (Trip trip : trips) {
                List stopTimes = dao.getStopTimesForTrip(trip);
                if (stopTimes.isEmpty()) continue;
                hasStopTimes = true;
            }
            if (hasStopTimes) continue;
            ++blocksRemoved;
            tripsRemoved += trips.size();
            _log.info("removing block " + blockId);
            for (Trip trip : trips) {
                dao.removeEntity((IdentityBean)trip);
            }
        }
        UpdateLibrary.clearDaoCache((GtfsRelationalDao)dao);
        _log.info("blocksRemoved=" + blocksRemoved + " tripsRemoved=" + tripsRemoved);
    }
}

