/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.Arrays;
import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.StopTime;

public class StopSequencePattern {
    private final AgencyAndId[] _stopIds;
    private final int[] _arrivalTimes;
    private final int[] _departureTimes;

    public StopSequencePattern(AgencyAndId[] stopIds, int[] arrivalTimes, int[] departureTimes) {
        this._stopIds = stopIds;
        this._arrivalTimes = arrivalTimes;
        this._departureTimes = departureTimes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this._arrivalTimes);
        result = 31 * result + Arrays.hashCode(this._departureTimes);
        result = 31 * result + Arrays.hashCode(this._stopIds);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StopSequencePattern other = (StopSequencePattern)obj;
        if (!Arrays.equals(this._arrivalTimes, other._arrivalTimes)) {
            return false;
        }
        if (!Arrays.equals(this._departureTimes, other._departureTimes)) {
            return false;
        }
        return Arrays.equals(this._stopIds, other._stopIds);
    }

    public static StopSequencePattern getPatternForStopTimes(List<StopTime> stopTimes) {
        int n = stopTimes.size();
        AgencyAndId[] stopIds = new AgencyAndId[n];
        int[] arrivalTimes = new int[n];
        int[] departureTimes = new int[n];
        for (int i = 0; i < n; ++i) {
            StopTime stopTime = stopTimes.get(i);
            stopIds[i] = stopTime.getStop().getId();
            arrivalTimes[i] = stopTime.getArrivalTime();
            departureTimes[i] = stopTime.getDepartureTime();
        }
        return new StopSequencePattern(stopIds, arrivalTimes, departureTimes);
    }
}

