/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.HashMap;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeRouteFromReferenceStrategyByLongName
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(MergeRouteFromReferenceStrategyByLongName.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        HashMap<String, Route> referenceRoutes = new HashMap<String, Route>();
        for (Route route : reference.getAllRoutes()) {
            referenceRoutes.put(route.getId().getId(), route);
        }
        for (Route route : dao.getAllRoutes()) {
            Route refRoute;
            String longname = route.getLongName();
            String identifier = "";
            if (longname != null) {
                String[] parts;
                if (longname.contains(" -") && (identifier = (parts = longname.split(" -"))[0]).length() > 2) {
                    identifier = identifier.substring(0, 2);
                }
            } else {
                identifier = route.getShortName();
            }
            if ((refRoute = (Route)referenceRoutes.get(identifier)) == null) continue;
            route.setShortName(refRoute.getShortName());
            route.setLongName(refRoute.getLongName());
            route.setType(refRoute.getType());
            route.setDesc(refRoute.getDesc());
            route.setUrl(refRoute.getUrl());
            route.setColor(refRoute.getColor());
            route.setTextColor(refRoute.getTextColor());
        }
    }
}

