/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class UpdateTripHeadsignRailRoadConvention
implements GtfsTransformStrategy {
    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        for (Trip trip : dao.getAllTrips()) {
            List stopTimes = dao.getStopTimesForTrip(trip);
            if (stopTimes == null || stopTimes.size() <= 0) continue;
            String existingTripHeadsign = trip.getTripHeadsign() != null ? trip.getTripHeadsign() : trip.getRouteShortName();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(((StopTime)stopTimes.get(0)).getDepartureTime() * 1000);
            calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
            SimpleDateFormat sdf = new SimpleDateFormat("h:mm a");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String newTripHeadsign = sdf.format(calendar.getTime()) + " to " + existingTripHeadsign;
            trip.setTripHeadsign(newTripHeadsign);
        }
    }
}

