/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.InterpolationLibrary;
import org.onebusaway.gtfs_transformer.updates.TripsByBlockInSortedOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpolateStopTimesFromTimePointsStrategy
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(InterpolateStopTimesFromTimePointsStrategy.class);

    @Override
    public String getName() {
        return InterpolateStopTimesFromTimePointsStrategy.class.getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        Map<String, List<Trip>> tripsByBlockId = TripsByBlockInSortedOrder.getTripsByBlockInSortedOrder(dao);
        this.clearNonTimepointTimes(dao, tripsByBlockId);
        this.interpolateArrivalAndDepartureTimes(dao, tripsByBlockId);
    }

    private void interpolateArrivalAndDepartureTimes(GtfsMutableRelationalDao dao, Map<String, List<Trip>> tripsByBlockId) {
        for (List<Trip> trips : tripsByBlockId.values()) {
            for (Trip trip : trips) {
                List stopTimes = dao.getStopTimesForTrip(trip);
                double[] distanceTraveled = this.getDistanceTraveledForStopTimes(stopTimes);
                int[] arrivalTimes = new int[stopTimes.size()];
                int[] departureTimes = new int[stopTimes.size()];
                this.interpolateArrivalAndDepartureTimes(dao, stopTimes, distanceTraveled, arrivalTimes, departureTimes);
                int sequence = 0;
                for (StopTime stopTime : stopTimes) {
                    stopTime.setArrivalTime(arrivalTimes[sequence]);
                    stopTime.setDepartureTime(departureTimes[sequence]);
                    ++sequence;
                    dao.updateEntity((Object)stopTime);
                }
            }
        }
    }

    private double[] getDistanceTraveledForStopTimes(List<StopTime> stopTimes) {
        double[] distances = new double[stopTimes.size()];
        for (int i = 0; i < stopTimes.size(); ++i) {
            distances[i] = stopTimes.get(i).getShapeDistTraveled();
        }
        return distances;
    }

    private void interpolateArrivalAndDepartureTimes(GtfsMutableRelationalDao dao, List<StopTime> stopTimes, double[] distanceTraveled, int[] arrivalTimes, int[] departureTimes) {
        TreeMap<Double, Integer> scheduleTimesByDistanceTraveled = new TreeMap<Double, Integer>();
        this.populateArrivalAndDepartureTimesByDistanceTravelledForStopTimes(stopTimes, distanceTraveled, scheduleTimesByDistanceTraveled);
        for (int i = 0; i < stopTimes.size(); ++i) {
            StopLocation stop;
            StopTime stopTime = stopTimes.get(i);
            double d = distanceTraveled[i];
            boolean hasDeparture = stopTime.isDepartureTimeSet();
            boolean hasArrival = stopTime.isArrivalTimeSet();
            int departureTime = stopTime.getDepartureTime();
            int arrivalTime = stopTime.getArrivalTime();
            if (hasDeparture && !hasArrival) {
                arrivalTime = departureTime;
            } else if (hasArrival && !hasDeparture) {
                departureTime = arrivalTime;
            } else if (!hasArrival && !hasDeparture) {
                int t;
                arrivalTime = t = (departureTimes[i] = (int)InterpolationLibrary.interpolate(scheduleTimesByDistanceTraveled, d));
                departureTime = t;
            }
            departureTimes[i] = departureTime;
            arrivalTimes[i] = arrivalTime;
            if (departureTimes[i] < arrivalTimes[i]) {
                throw new IllegalStateException("departure time is less than arrival time for stop time with trip_id=" + stopTime.getTrip().getId() + " stop_sequence=" + stopTime.getStopSequence());
            }
            if (i <= 0 || arrivalTimes[i] >= departureTimes[i - 1]) continue;
            StopTime prevStopTime = stopTimes.get(i - 1);
            StopLocation prevStop = prevStopTime.getStop();
            if (prevStop.equals(stop = stopTime.getStop()) && arrivalTimes[i] == departureTimes[i - 1] - 1) {
                this._log.info("fixing decreasing passingTimes: stopTimeA=" + prevStopTime.getId() + " stopTimeB=" + stopTime.getId());
                arrivalTimes[i] = departureTimes[i - 1];
                if (departureTimes[i] >= arrivalTimes[i]) continue;
                departureTimes[i] = arrivalTimes[i];
                continue;
            }
            if (this.isLenientMode() && i > 0 && arrivalTimes[i] < arrivalTimes[i - 1] && departureTimes[i] < departureTimes[i - 1]) {
                int t0 = (int)InterpolationLibrary.interpolate(scheduleTimesByDistanceTraveled, distanceTraveled[i - 1]);
                int t1 = (int)InterpolationLibrary.interpolate(scheduleTimesByDistanceTraveled, distanceTraveled[i]);
                if (t1 < t0) {
                    int m = t0;
                    t0 = t1;
                    t1 = m;
                    this._log.warn("interpolation error");
                }
                this._log.warn("correcting arrival time of sequence " + (stopTime.getStopSequence() - 1) + ", " + stopTime.getStopSequence() + " of trip " + stopTime.getTrip().getId() + " as it was less than last departure time.  Arrival[" + (i - 1) + "] " + arrivalTimes[i - 1] + " now " + t0 + ", Arrival[" + i + "] " + arrivalTimes[i] + " now " + t1);
                int n = t0;
                departureTimes[i - 1] = n;
                arrivalTimes[i - 1] = n;
                arrivalTimes[i] = departureTimes[i] = t1;
                continue;
            }
            for (int x = 0; x < stopTimes.size(); ++x) {
                StopTime st = stopTimes.get(x);
                String msg = x + " " + st.getId() + " " + arrivalTimes[x] + " " + departureTimes[x];
                this._log.error(msg);
                System.err.println(msg);
            }
            String exceptionMessage = "arrival time is less than previous departure time for stop time  with isLenientArrivalDepartureTimes=" + this.isLenientArrivalDepartureTimes() + " and trip_id=" + stopTime.getTrip().getId() + " stop_sequence=" + stopTime.getStopSequence() + ", arrivalTime=" + arrivalTimes[i] + ", departureTime=" + departureTimes[i] + (String)(i > 0 ? " arrivalTimes[" + (i - 1) + "]=" + arrivalTimes[i - 1] + ", departureTimes[" + (i - 1) + "]=" + departureTimes[i - 1] : " (i<1)");
            this._log.error(exceptionMessage);
            throw new IllegalStateException(exceptionMessage);
        }
    }

    private boolean isLenientArrivalDepartureTimes() {
        return false;
    }

    private boolean isLenientMode() {
        return false;
    }

    private void populateArrivalAndDepartureTimesByDistanceTravelledForStopTimes(List<StopTime> stopTimes, double[] distances, SortedMap<Double, Integer> scheduleTimesByDistanceTraveled) {
        for (int i = 0; i < stopTimes.size(); ++i) {
            double d;
            StopTime stopTime = stopTimes.get(i);
            double arrivalDistance = d = distances[i];
            double departureDistance = d + 1.0E-6;
            if (!(stopTime.getArrivalTime() < 0 || scheduleTimesByDistanceTraveled.containsKey(arrivalDistance) && (Integer)scheduleTimesByDistanceTraveled.get(arrivalDistance) <= stopTime.getArrivalTime())) {
                scheduleTimesByDistanceTraveled.put(arrivalDistance, stopTime.getArrivalTime());
            }
            if (stopTime.getDepartureTime() < 0 || scheduleTimesByDistanceTraveled.containsKey(departureDistance) && (Integer)scheduleTimesByDistanceTraveled.get(departureDistance) >= stopTime.getDepartureTime()) continue;
            scheduleTimesByDistanceTraveled.put(departureDistance, stopTime.getDepartureTime());
        }
    }

    private void clearNonTimepointTimes(GtfsMutableRelationalDao dao, Map<String, List<Trip>> tripsByBlockId) {
        for (List<Trip> trips : tripsByBlockId.values()) {
            for (Trip trip : trips) {
                List stopTimes = dao.getStopTimesForTrip(trip);
                int timepoints = this.countTimepoints(stopTimes);
                if (timepoints <= 1) continue;
                int count = 0;
                for (StopTime stopTime : stopTimes) {
                    if (0 != stopTime.getTimepoint() || ++count >= stopTimes.size()) continue;
                    stopTime.clearArrivalTime();
                    stopTime.clearDepartureTime();
                    dao.updateEntity((Object)stopTime);
                }
            }
        }
    }

    private int countTimepoints(List<StopTime> stopTimes) {
        int count = 0;
        for (StopTime stopTime : stopTimes) {
            if (1 != stopTime.getTimepoint()) continue;
            ++count;
        }
        return count;
    }
}

