/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.List;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalVsExpressUpdateStrategy
implements GtfsTransformStrategy {
    private static Logger _log = LoggerFactory.getLogger(LocalVsExpressUpdateStrategy.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        _log.info("running");
        for (Route route : dao.getAllRoutes()) {
            List trips = dao.getTripsForRoute(route);
            if (trips.isEmpty()) continue;
            int localCount = 0;
            int expressCount = 0;
            for (Trip trip : trips) {
                if (trip.getTripShortName() != null) {
                    boolean isExpress = trip.getTripShortName().equals("EXPRESS");
                    if (isExpress) {
                        ++expressCount;
                        continue;
                    }
                    ++localCount;
                    continue;
                }
                ++localCount;
            }
            boolean addLocalVsExpressToTripName = localCount > 0 && expressCount > 0;
            for (Trip trip : trips) {
                String tripHeadsign;
                boolean isExpress;
                if (trip == null || trip.getTripShortName() == null || !(isExpress = trip.getTripShortName().equals("EXPRESS"))) continue;
                _log.info("route(" + route.getShortName() + ") gets an E for trip " + trip.getId());
                trip.setRouteShortName(trip.getRoute().getShortName() + "E");
                if (!addLocalVsExpressToTripName || (tripHeadsign = trip.getTripHeadsign()) == null) continue;
                trip.setTripHeadsign(tripHeadsign + " - Express");
            }
        }
    }
}

