/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyRouteService
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(VerifyRouteService.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        String feed = CloudContextService.getLikelyFeedName(dao);
        ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
        Date today = this.removeTime(new Date());
        Date tomorrow = this.removeTime(this.addDays(new Date(), 1));
        Date nextDay = this.removeTime(this.addDays(new Date(), 2));
        Date dayAfterNext = this.removeTime(this.addDays(new Date(), 3));
        int numRoutesToday = this.hasRouteServiceForDate(dao, today, es);
        if (!this.isWeekend(today)) {
            es.publishMetric(CloudContextService.getNamespace(), "WeekdayActiveSubwayRoutesToday", "feed", feed, (double)numRoutesToday);
        }
        int numRoutesTommorrow = this.hasRouteServiceForDate(dao, tomorrow, es);
        if (!this.isWeekend(tomorrow)) {
            es.publishMetric(CloudContextService.getNamespace(), "WeekdayActiveSubwayRoutesTomorrow", "feed", feed, (double)numRoutesTommorrow);
        }
        int numRoutesIn2Days = this.hasRouteServiceForDate(dao, nextDay, es);
        if (!this.isWeekend(nextDay)) {
            es.publishMetric(CloudContextService.getNamespace(), "WeekdayActiveSubwayRoutesIn2Days", "feed", feed, (double)numRoutesIn2Days);
        }
        int numRoutesIn3Days = this.hasRouteServiceForDate(dao, dayAfterNext, es);
        if (!this.isWeekend(dayAfterNext)) {
            es.publishMetric(CloudContextService.getNamespace(), "WeekdayActiveSubwayRoutesIn3Days", "feed", feed, (double)numRoutesIn3Days);
        }
        this._log.info("Feed for metrics: {}", (Object)feed);
        this._log.info("Active routes: {}: {}; {}: {}; {}: {}; {}: {}", new Object[]{this.formatDate(today), numRoutesToday, this.formatDate(tomorrow), numRoutesTommorrow, this.formatDate(nextDay), numRoutesIn2Days, this.formatDate(dayAfterNext), numRoutesIn3Days});
        es.publishMetric(CloudContextService.getNamespace(), "RoutesContainingTripsToday", "feed", feed, (double)numRoutesToday);
        es.publishMetric(CloudContextService.getNamespace(), "RoutesContainingTripsTomorrow", "feed", feed, (double)numRoutesTommorrow);
        es.publishMetric(CloudContextService.getNamespace(), "RoutesContainingTripsIn2Days", "feed", feed, (double)numRoutesIn2Days);
        es.publishMetric(CloudContextService.getNamespace(), "RoutesContainingTripsIn3Days", "feed", feed, (double)numRoutesIn3Days);
        if (numRoutesToday < 3) {
            throw new IllegalStateException("Route service missing in agency: " + dao.getAllAgencies().iterator().next());
        }
    }

    private int hasRouteServiceForDate(GtfsMutableRelationalDao dao, Date testDate, ExternalServices es) {
        int numTripsOnDate = 0;
        int activeRoutes = 0;
        for (Route route : dao.getAllRoutes()) {
            numTripsOnDate = 0;
            for (Trip trip : dao.getTripsForRoute(route)) {
                for (ServiceCalendarDate calDate : dao.getCalendarDatesForServiceId(trip.getServiceId())) {
                    Date date = this.constructDate(calDate.getDate());
                    if (calDate.getExceptionType() != 1 || !date.equals(testDate)) continue;
                    ++numTripsOnDate;
                }
            }
            if (numTripsOnDate == 0) {
                this._log.info("No service for {} on {}", (Object)route.getId().getId(), (Object)testDate);
                continue;
            }
            ++activeRoutes;
            this._log.info("Route: {} {} Number of trips: {}", new Object[]{route.getId().getId(), this.formatDate(testDate), numTripsOnDate});
            String metricName = "TripsOnRoute" + route.getId().getId();
            es.publishMetric(CloudContextService.getNamespace(), metricName, "day", this.formatDate(testDate), (double)numTripsOnDate);
        }
        return activeRoutes;
    }

    private boolean isWeekend(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int day = cal.get(7);
        return day == 1 || day == 7;
    }

    private Date constructDate(ServiceDate date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, date.getYear());
        calendar.set(2, date.getMonth() - 1);
        calendar.set(5, date.getDay());
        Date date1 = calendar.getTime();
        date1 = this.removeTime(date1);
        return date1;
    }

    private Date removeTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }

    private Date addDays(Date date, int daysToAdd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, daysToAdd);
        return cal.getTime();
    }

    private String formatDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd yyyy");
        return dateFormat.format(date);
    }

    private ServiceDate createServiceDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new ServiceDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }
}

