/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.deferred;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.Converter;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_transformer.deferred.DeferredValueSupport;
import org.onebusaway.gtfs_transformer.deferred.EntitySchemaCache;

public class DeferredValueConverter {
    private final DeferredValueSupport _support;
    private final GtfsRelationalDao _dao;

    public DeferredValueConverter(GtfsReader reader, EntitySchemaCache schemaCache, GtfsRelationalDao dao) {
        this._support = new DeferredValueSupport(reader, schemaCache);
        this._dao = dao;
    }

    public Object convertValue(BeanWrapper targetBean, String targetPropertyName, Object value) {
        Class<?> idType;
        if (value == null) {
            return null;
        }
        Class expectedValueType = targetBean.getPropertyType(targetPropertyName);
        Class<?> actualValueType = value.getClass();
        Object parentObject = targetBean.getWrappedInstance(Object.class);
        if (parentObject instanceof IdentityBean && targetPropertyName.equals("id") && (idType = this.getIdentityBeanIdType(parentObject)) == AgencyAndId.class && actualValueType == String.class) {
            return this._support.resolveAgencyAndId(targetBean, targetPropertyName, (String)value);
        }
        if (expectedValueType.isAssignableFrom(actualValueType)) {
            return value;
        }
        if (this.isPrimitiveAssignable(expectedValueType, actualValueType)) {
            return value;
        }
        if (actualValueType == String.class) {
            String stringValue = (String)value;
            if (AgencyAndId.class.isAssignableFrom(expectedValueType)) {
                return this._support.resolveAgencyAndId(targetBean, targetPropertyName, stringValue);
            }
            if (IdentityBean.class.isAssignableFrom(expectedValueType)) {
                Object entity;
                String id = stringValue;
                if (DeferredValueConverter.getIdType(expectedValueType) == AgencyAndId.class) {
                    GtfsReaderContext context = this._support.getReader().getGtfsReaderContext();
                    String agencyId = context.getAgencyForEntity(expectedValueType, stringValue);
                    id = new AgencyAndId(agencyId, stringValue);
                }
                if ((entity = this._dao.getEntityForId(expectedValueType, (Serializable)((Object)id))) == null) {
                    throw new IllegalStateException("entity not found: type=" + expectedValueType.getName() + " id=" + (Serializable)((Object)id));
                }
                return entity;
            }
            Class<?> parentEntityType = parentObject.getClass();
            Converter converter = this._support.resolveConverter(parentEntityType, targetPropertyName, expectedValueType);
            if (converter != null) {
                return converter.convert(expectedValueType, value);
            }
        }
        throw new IllegalStateException("no conversion possible from type \"" + actualValueType.getName() + "\" to type \"" + expectedValueType.getName() + "\"");
    }

    private Class<?> getIdentityBeanIdType(Object bean) {
        try {
            return bean.getClass().getMethod("getId", new Class[0]).getReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isPrimitiveAssignable(Class<?> expectedValueType, Class<?> actualValueType) {
        if (!expectedValueType.isPrimitive()) {
            return false;
        }
        return expectedValueType == Double.TYPE && (actualValueType == Double.class || actualValueType == Float.class) || expectedValueType == Long.TYPE && (actualValueType == Long.class || actualValueType == Integer.class || actualValueType == Short.class) || expectedValueType == Integer.TYPE && (actualValueType == Integer.class || actualValueType == Short.class) || expectedValueType == Short.TYPE && actualValueType == Short.class || expectedValueType == Boolean.TYPE && actualValueType == Boolean.class;
    }

    private static Class<?> getIdType(Class<?> valueType) {
        try {
            Method m = valueType.getMethod("getId", new Class[0]);
            return m.getReturnType();
        }
        catch (Throwable ex) {
            throw new IllegalStateException("could not find method \"getId\" for IdentityBean classs", ex);
        }
    }
}

