/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Transfer;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;

public class RemoveEntityLibrary {
    public void removeAgency(GtfsMutableRelationalDao dao, Agency agency) {
        for (Route route : dao.getRoutesForAgency(agency)) {
            this.removeRoute(dao, route);
        }
        dao.removeEntity((IdentityBean)agency);
    }

    public void removeRoute(GtfsMutableRelationalDao dao, Route route) {
        for (Trip trip : dao.getTripsForRoute(route)) {
            this.removeTrip(dao, trip);
        }
        dao.removeEntity((IdentityBean)route);
    }

    public void removeTrip(GtfsMutableRelationalDao dao, Trip trip) {
        for (StopTime stopTime : dao.getStopTimesForTrip(trip)) {
            this.removeStopTime(dao, stopTime);
        }
        for (Frequency frequency : dao.getFrequenciesForTrip(trip)) {
            this.removeFrequency(dao, frequency);
        }
        dao.removeEntity((IdentityBean)trip);
    }

    public void removeFrequency(GtfsMutableRelationalDao dao, Frequency frequency) {
        dao.removeEntity((IdentityBean)frequency);
    }

    public void removeStop(GtfsMutableRelationalDao dao, Stop stop) {
        for (StopTime stopTime : dao.getStopTimesForStop(stop)) {
            this.removeStopTime(dao, stopTime);
        }
        dao.removeEntity((IdentityBean)stop);
    }

    public void removeStopTime(GtfsMutableRelationalDao dao, StopTime stopTime) {
        dao.removeEntity((IdentityBean)stopTime);
    }

    public void removeServiceCalendar(GtfsMutableRelationalDao dao, ServiceCalendar calendar) {
        dao.removeEntity((IdentityBean)calendar);
    }

    public void removeServiceCalendarDate(GtfsMutableRelationalDao dao, ServiceCalendarDate calendarDate) {
        dao.removeEntity((IdentityBean)calendarDate);
    }

    public void removeCalendar(GtfsMutableRelationalDao dao, AgencyAndId serviceId) {
        ServiceCalendar calendar = dao.getCalendarForServiceId(serviceId);
        if (calendar != null) {
            this.removeServiceCalendar(dao, calendar);
        }
        for (ServiceCalendarDate calendarDate : dao.getCalendarDatesForServiceId(serviceId)) {
            this.removeServiceCalendarDate(dao, calendarDate);
        }
        for (Trip trip : dao.getTripsForServiceId(serviceId)) {
            this.removeTrip(dao, trip);
        }
    }

    public void removeTransfer(GtfsMutableRelationalDao dao, Transfer transfer) {
        dao.removeEntity((IdentityBean)transfer);
    }

    public void removeFeedInfo(GtfsMutableRelationalDao dao, FeedInfo feedInfo) {
        dao.removeEntity((IdentityBean)feedInfo);
    }
}

