/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.csv_entities.CSVLibrary;
import org.onebusaway.csv_entities.CSVListener;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnomalyCheckFutureTripCounts
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(AnomalyCheckFutureTripCounts.class);
    @CsvField(optional=true)
    private String datesToIgnoreUrl;
    @CsvField(optional=true)
    private String datesToIgnoreFile;
    @CsvField(optional=true)
    private String holidaysUrl;
    @CsvField(optional=true)
    private String holidaysFile;
    @CsvField(optional=true)
    private String dayAvgTripMapUrl;
    @CsvField(optional=true)
    private String dayAvgTripMapFile;
    @CsvField(optional=true)
    private double percentageMatch = 10.0;
    @CsvField(optional=true)
    private boolean silentMode = true;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        SetListener datesToIgnoreListener = new SetListener();
        datesToIgnoreListener = (SetListener)this.readCsvFrom(datesToIgnoreListener, this.datesToIgnoreUrl, this.datesToIgnoreFile);
        Collection<Date> datesToIgnore = datesToIgnoreListener.returnContents();
        SetListener holidaysListener = new SetListener();
        holidaysListener = (SetListener)this.readCsvFrom(holidaysListener, this.holidaysUrl, this.holidaysFile);
        Collection<Date> holidays = holidaysListener.returnContents();
        Map<Object, Object> dayAvgTripsMap = new HashMap();
        MapListener mapListener = new MapListener();
        mapListener = (MapListener)this.readCsvFrom(mapListener, this.dayAvgTripMapUrl, this.dayAvgTripMapFile);
        dayAvgTripsMap = mapListener.returnContents();
        SimpleDateFormat dayOfWeekFormat = new SimpleDateFormat("EEEE");
        for (Date date : holidays) {
            this._log.info("holiday: " + date.toString() + " on a " + dayOfWeekFormat.format(date));
        }
        for (Date date : datesToIgnore) {
            this._log.info("ignore: " + date.toString());
        }
        for (String string : dayAvgTripsMap.keySet()) {
            this._log.info("key: " + string + " value: " + dayAvgTripsMap.get(string));
        }
        ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
        String[] stringArray = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday", "Holiday"};
        Map<Date, Integer> dateTripMap = this.getDateTripMap(dao);
        int dayCounter = 0;
        HashMap dayAvgTripsMapUpdate = new HashMap();
        for (String day : stringArray) {
            dayAvgTripsMapUpdate.put(day, new ArrayList());
        }
        Date dateDay = this.removeTime(this.addDays(new Date(), dayCounter));
        while (dateTripMap.get(dateDay) != null) {
            int tripCount = dateTripMap.get(dateDay);
            if (this.dayAvgTripMapFile == null && this.dayAvgTripMapUrl == null) {
                this._log.info("On {} there are {} trips", (Object)dateDay.toString(), (Object)tripCount);
            } else if ((double)tripCount < (Double)dayAvgTripsMap.get(dayOfWeekFormat.format(dateDay)) * (1.0 + this.percentageMatch / 100.0) && (double)tripCount > (Double)dayAvgTripsMap.get(dayOfWeekFormat.format(dateDay)) * (1.0 - this.percentageMatch / 100.0) && !holidays.contains(dateDay)) {
                this._log.info(dateDay + " has " + tripCount + " trips, and that's within reasonable expections");
                ((ArrayList)dayAvgTripsMapUpdate.get(dayOfWeekFormat.format(dateDay))).add(Double.valueOf(tripCount));
            } else if (holidays.contains(dateDay) & ((double)tripCount < (Double)dayAvgTripsMap.get("Holiday") * (1.0 + this.percentageMatch / 100.0) && (double)tripCount > (Double)dayAvgTripsMap.get("Holiday") * (1.0 - this.percentageMatch / 100.0))) {
                this._log.info(dateDay + " has " + tripCount + " trips, is a holiday, and that's within reasonable expections");
                ((ArrayList)dayAvgTripsMapUpdate.get("Holiday")).add(Double.valueOf(tripCount));
            } else if (datesToIgnore.contains(dateDay)) {
                this._log.info(dateDay + " has " + tripCount + " trips, and we are ignoring this possible anomoly");
            } else {
                this._log.info(dateDay + " has " + tripCount + " trips, this may indicate a problem.");
                if (!this.silentMode) {
                    es.publishMessage(CloudContextService.getTopic(), dateDay.toString() + " has " + tripCount + " trips, this may indicate a problem.");
                }
            }
            dateDay = this.removeTime(this.addDays(new Date(), ++dayCounter));
        }
        Object out = "";
        for (String stringDay : stringArray) {
            double tripsUpcoming;
            try {
                tripsUpcoming = ((ArrayList)dayAvgTripsMapUpdate.get(stringDay)).stream().mapToDouble(a -> a).average().getAsDouble();
            }
            catch (NoSuchElementException exception) {
                tripsUpcoming = (Double)dayAvgTripsMap.get(stringDay);
            }
            double currentAvg = (Double)dayAvgTripsMap.get(stringDay);
            int aprox_hours_per_month = 672;
            double suggestedAvg = currentAvg + (tripsUpcoming - currentAvg) / (double)aprox_hours_per_month;
            out = (String)out + stringDay + "," + suggestedAvg + "\n";
        }
        this._log.info((String)out);
        try {
            Files.deleteIfExists(Paths.get(this.dayAvgTripMapFile, new String[0]));
            Files.write(Paths.get(this.dayAvgTripMapFile, new String[0]), ((String)out).getBytes(), new OpenOption[0]);
        }
        catch (IOException io) {
            this._log.error(io.getMessage());
        }
    }

    private Map<Date, Integer> getDateTripMap(GtfsMutableRelationalDao dao) {
        HashMap<Date, Integer> dateTripMap = new HashMap<Date, Integer>();
        for (Trip trip : dao.getAllTrips()) {
            ServiceCalendar servCal;
            this._log.debug(trip.toString());
            boolean hasCalDateException = false;
            for (ServiceCalendarDate calDate : dao.getCalendarDatesForServiceId(trip.getServiceId())) {
                Date date = this.constructDate(calDate.getDate());
                if (dateTripMap.get(date) == null) {
                    dateTripMap.put(date, 1);
                    continue;
                }
                dateTripMap.put(date, (Integer)dateTripMap.get(date) + 1);
            }
            if (hasCalDateException || (servCal = dao.getCalendarForServiceId(trip.getServiceId())) == null) continue;
            Date start = this.removeTime(servCal.getStartDate().getAsDate());
            this._log.info(start.toString());
            Date end = this.removeTime(servCal.getEndDate().getAsDate());
            this._log.info(end.toString());
        }
        return dateTripMap;
    }

    private Date addDays(Date date, int daysToAdd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, daysToAdd);
        return cal.getTime();
    }

    private Date constructDate(ServiceDate date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, date.getYear());
        calendar.set(2, date.getMonth() - 1);
        calendar.set(5, date.getDay());
        Date date1 = calendar.getTime();
        date1 = this.removeTime(date1);
        return date1;
    }

    private Date removeTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }

    public void setDatesToIgnoreUrl(String url) {
        this.datesToIgnoreUrl = url;
    }

    public void setDatesToIgnoreFile(String url) {
        this.datesToIgnoreFile = url;
    }

    public void setDayAvgTripMapUrl(String url) {
        this.dayAvgTripMapUrl = url;
    }

    public void setDayAvgTripMapFile(String url) {
        this.dayAvgTripMapFile = url;
    }

    public void setHolidaysUrl(String url) {
        this.holidaysUrl = url;
    }

    public void setHolidaysFile(String url) {
        this.holidaysFile = url;
    }

    public void setPercentageMatch(double percentageMatch) {
        this.percentageMatch = percentageMatch;
    }

    public void setSilentMode(boolean silentMode) {
        this.silentMode = silentMode;
    }

    private CSVListener readCsvFrom(CSVListener listener, String urlSource, String fileSource) {
        try {
            if (urlSource != null) {
                URL url = new URL(urlSource);
                try (InputStream is = url.openStream();){
                    new CSVLibrary().parse(is, listener);
                }
            }
            if (fileSource != null) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileSource));
                new CSVLibrary().parse((InputStream)is, listener);
            }
        }
        catch (Exception e) {
            this._log.error(e.getMessage());
        }
        return listener;
    }

    private static class MapListener
    implements CSVListener {
        private Map<String, Double> inputMap = new HashMap<String, Double>();

        private MapListener() {
        }

        public void handleLine(List<String> list) {
            this.inputMap.put(list.get(0), Double.parseDouble(list.get(1)));
        }

        Map<String, Double> returnContents() {
            return this.inputMap;
        }
    }

    private static class SetListener
    implements CSVListener {
        private Collection<Date> inputSet = new HashSet<Date>();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");

        private SetListener() {
        }

        public void handleLine(List<String> list) throws Exception {
            this.inputSet.add(this.dateFormatter.parse(list.get(0)));
        }

        Collection<Date> returnContents() {
            return this.inputSet;
        }
    }
}

