/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.onebusaway.collections.Counter;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs_transformer.updates.TripKey;

public class CalendarSimplicationLibrary {
    private int _minNumberOfWeeksForCalendarEntry = 3;
    private double _dayOfTheWeekInclusionRatio = 0.5;

    public void setMinNumberOfWeeksForCalendarEntry(int minNumberOfWeeksForCalendarEntry) {
        this._minNumberOfWeeksForCalendarEntry = minNumberOfWeeksForCalendarEntry;
    }

    public int getMinNumberOfWeeksForCalendarEntry() {
        return this._minNumberOfWeeksForCalendarEntry;
    }

    public void setDayOfTheWeekInclusionRatio(double dayOfTheWeekInclusionRatio) {
        this._dayOfTheWeekInclusionRatio = dayOfTheWeekInclusionRatio;
    }

    public double getDayOfTheWeekInclusionRatio() {
        return this._dayOfTheWeekInclusionRatio;
    }

    public Map<Set<AgencyAndId>, List<TripKey>> groupTripKeysByServiceIds(Map<TripKey, List<Trip>> tripsByKey) {
        FactoryMap tripKeysByServiceIds = new FactoryMap(new ArrayList());
        for (Map.Entry<TripKey, List<Trip>> entry : tripsByKey.entrySet()) {
            TripKey key = entry.getKey();
            List<Trip> tripsForKey = entry.getValue();
            HashSet<AgencyAndId> serviceIds = new HashSet<AgencyAndId>();
            for (Trip trip : tripsForKey) {
                serviceIds.add(trip.getServiceId());
            }
            ((List)tripKeysByServiceIds.get(serviceIds)).add(key);
        }
        return tripKeysByServiceIds;
    }

    public void computeSimplifiedCalendar(AgencyAndId updatedServiceId, ServiceCalendarSummary summary, List<Object> newEntities) {
        boolean useDateRange;
        List<ServiceDate> serviceDatesInOrder = summary.serviceDatesInOrder;
        Set<Integer> daysOfTheWeekToUse = summary.daysOfTheWeekToUse;
        if (serviceDatesInOrder.isEmpty()) {
            return;
        }
        ServiceDate fromDate = serviceDatesInOrder.get(0);
        ServiceDate toDate = serviceDatesInOrder.get(serviceDatesInOrder.size() - 1);
        boolean bl = useDateRange = summary.maxDayOfWeekCount >= this._minNumberOfWeeksForCalendarEntry;
        if (useDateRange) {
            ServiceCalendar sc = this.createServiceCalendar(updatedServiceId, daysOfTheWeekToUse, fromDate, toDate);
            newEntities.add(sc);
        }
        TimeZone tz = TimeZone.getTimeZone("UTC");
        ServiceDate serviceDate = fromDate;
        while (serviceDate.compareTo(toDate) <= 0) {
            boolean isActive = summary.allServiceDates.contains(serviceDate);
            Calendar serviceDateAsCalendar = serviceDate.getAsCalendar(tz);
            if (useDateRange) {
                ServiceCalendarDate scd;
                int dayOfWeek = serviceDateAsCalendar.get(7);
                boolean dateRangeIncludesServiceDate = daysOfTheWeekToUse.contains(dayOfWeek);
                if (isActive && !dateRangeIncludesServiceDate) {
                    scd = new ServiceCalendarDate();
                    scd.setDate(serviceDate);
                    scd.setExceptionType(1);
                    scd.setServiceId(updatedServiceId);
                    newEntities.add(scd);
                }
                if (!isActive && dateRangeIncludesServiceDate) {
                    scd = new ServiceCalendarDate();
                    scd.setDate(serviceDate);
                    scd.setExceptionType(2);
                    scd.setServiceId(updatedServiceId);
                    newEntities.add(scd);
                }
            } else if (isActive) {
                ServiceCalendarDate scd = new ServiceCalendarDate();
                scd.setDate(serviceDate);
                scd.setExceptionType(1);
                scd.setServiceId(updatedServiceId);
                newEntities.add(scd);
            }
            serviceDate = serviceDate.next();
        }
    }

    public ServiceCalendarSummary getSummaryForServiceDates(Set<ServiceDate> allServiceDates) {
        ServiceCalendarSummary summary = new ServiceCalendarSummary();
        summary.allServiceDates = allServiceDates;
        summary.serviceDatesInOrder = new ArrayList<ServiceDate>(summary.allServiceDates);
        Collections.sort(summary.serviceDatesInOrder);
        if (summary.serviceDatesInOrder.isEmpty()) {
            return summary;
        }
        Calendar c = Calendar.getInstance();
        Counter daysOfTheWeekCounts = new Counter();
        for (ServiceDate serviceDate : summary.serviceDatesInOrder) {
            c.setTime(serviceDate.getAsDate());
            c.add(11, 12);
            int dayOfTheWeek = c.get(7);
            daysOfTheWeekCounts.increment((Object)dayOfTheWeek);
            summary.mostRecentServiceDateByDayOfWeek.put(dayOfTheWeek, serviceDate);
        }
        Integer maxKey = (Integer)daysOfTheWeekCounts.getMax();
        summary.maxDayOfWeekCount = daysOfTheWeekCounts.getCount((Object)maxKey);
        for (Integer dayOfTheWeek : daysOfTheWeekCounts.getKeys()) {
            int count = daysOfTheWeekCounts.getCount((Object)dayOfTheWeek);
            if ((double)count < (double)summary.maxDayOfWeekCount * this._dayOfTheWeekInclusionRatio) continue;
            summary.daysOfTheWeekToUse.add(dayOfTheWeek);
        }
        return summary;
    }

    private ServiceCalendar createServiceCalendar(AgencyAndId updatedServiceId, Set<Integer> daysOfTheWeekToUse, ServiceDate fromDate, ServiceDate toDate) {
        ServiceCalendar sc = new ServiceCalendar();
        sc.setServiceId(updatedServiceId);
        sc.setStartDate(fromDate);
        sc.setEndDate(toDate);
        if (daysOfTheWeekToUse.contains(2)) {
            sc.setMonday(1);
        }
        if (daysOfTheWeekToUse.contains(3)) {
            sc.setTuesday(1);
        }
        if (daysOfTheWeekToUse.contains(4)) {
            sc.setWednesday(1);
        }
        if (daysOfTheWeekToUse.contains(5)) {
            sc.setThursday(1);
        }
        if (daysOfTheWeekToUse.contains(6)) {
            sc.setFriday(1);
        }
        if (daysOfTheWeekToUse.contains(7)) {
            sc.setSaturday(1);
        }
        if (daysOfTheWeekToUse.contains(1)) {
            sc.setSunday(1);
        }
        return sc;
    }

    public static class ServiceCalendarSummary {
        public int maxDayOfWeekCount;
        public Set<ServiceDate> allServiceDates = new HashSet<ServiceDate>();
        public List<ServiceDate> serviceDatesInOrder = new ArrayList<ServiceDate>();
        public Set<Integer> daysOfTheWeekToUse = new HashSet<Integer>();
        public Map<Integer, ServiceDate> mostRecentServiceDateByDayOfWeek = new HashMap<Integer, ServiceDate>();
    }
}

