/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.factory;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.beans.DefaultPropertyMethodResolver;
import org.onebusaway.collections.beans.PropertyMethod;
import org.onebusaway.collections.tuple.T2;
import org.onebusaway.collections.tuple.Tuples;
import org.onebusaway.csv_entities.schema.SingleFieldMapping;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_transformer.deferred.EntitySchemaCache;

class PropertyMethodResolverImpl
extends DefaultPropertyMethodResolver {
    private final GtfsRelationalDao _dao;
    private final EntitySchemaCache _schemaCache;
    private Map<T2<Class, String>, PropertyMethod> _virtualPropertyMethods = new HashMap<T2<Class, String>, PropertyMethod>();

    public PropertyMethodResolverImpl(GtfsRelationalDao dao, EntitySchemaCache schemaCache) {
        this._dao = dao;
        this._schemaCache = schemaCache;
        this.addVirtualProperty(Agency.class, "routes", new RoutesForAgencyPropertyMethod());
        this.addVirtualProperty(Route.class, "trips", new TripsForRoutePropertyMethod());
        this.addVirtualProperty(Trip.class, "stop_times", new StopTimesForTripPropertyMethod());
        this.addVirtualProperty(Trip.class, "calendar", new ServiceCalendarForTripPropertyMethod());
    }

    public PropertyMethod getPropertyMethod(Class<?> targetType, String propertyName) {
        PropertyMethod method = this._virtualPropertyMethods.get(Tuples.tuple(targetType, (Object)propertyName));
        if (method != null) {
            return method;
        }
        SingleFieldMapping mapping = this._schemaCache.getFieldMappingForCsvFieldName(targetType, propertyName);
        if (mapping != null) {
            propertyName = mapping.getObjFieldName();
        }
        return super.getPropertyMethod(targetType, propertyName);
    }

    private void addVirtualProperty(Class entityType, String propertyName, PropertyMethod method) {
        T2 key = Tuples.tuple((Object)entityType, (Object)propertyName);
        this._virtualPropertyMethods.put((T2<Class, String>)key, method);
    }

    private class RoutesForAgencyPropertyMethod
    extends ListPropertyMethod {
        private RoutesForAgencyPropertyMethod() {
        }

        public Object invoke(Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return PropertyMethodResolverImpl.this._dao.getRoutesForAgency((Agency)value);
        }
    }

    private class TripsForRoutePropertyMethod
    extends ListPropertyMethod {
        private TripsForRoutePropertyMethod() {
        }

        public Object invoke(Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return PropertyMethodResolverImpl.this._dao.getTripsForRoute((Route)value);
        }
    }

    private class StopTimesForTripPropertyMethod
    extends ListPropertyMethod {
        private StopTimesForTripPropertyMethod() {
        }

        public Object invoke(Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return PropertyMethodResolverImpl.this._dao.getStopTimesForTrip((Trip)value);
        }
    }

    private class ServiceCalendarForTripPropertyMethod
    extends ListPropertyMethod {
        private ServiceCalendarForTripPropertyMethod() {
        }

        public Object invoke(Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return PropertyMethodResolverImpl.this._dao.getCalendarForServiceId(((Trip)value).getServiceId());
        }
    }

    private abstract class ListPropertyMethod
    implements PropertyMethod {
        private ListPropertyMethod() {
        }

        public Class<?> getReturnType() {
            return List.class;
        }
    }
}

