/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCalendarDatesForDuplicateTrips
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(UpdateCalendarDatesForDuplicateTrips.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        if (dao == null || dao.getAllTrips().isEmpty()) {
            throw new IllegalStateException("nothing to do!");
        }
        String calendarAgencyId = ((Trip)dao.getAllTrips().iterator().next()).getId().getAgencyId();
        DuplicateState state = new DuplicateState(dao, calendarAgencyId);
        HashMap<String, ArrayList<Trip>> tripsByMtaTripId = this.buildTripMap(state, dao);
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        HashMap<String, Trip> referenceTripsByTripIdByTripId = new HashMap<String, Trip>();
        for (Trip trip : reference.getAllTrips()) {
            referenceTripsByTripIdByTripId.put(trip.getId().getId(), trip);
        }
        this.logDuplicates(tripsByMtaTripId, referenceTripsByTripIdByTripId);
        this._log.info("Incoming Routes: {} Trips: {} Stops: {} Stop times: {} CalDatess: {} ", new Object[]{dao.getAllRoutes().size(), dao.getAllTrips().size(), dao.getAllStops().size(), dao.getAllStopTimes().size(), dao.getAllCalendarDates().size()});
        this.update(dao, state, tripsByMtaTripId);
        state.apply();
        this._log.info("Outgoing Routes: {} Trips: {} Stops: {} Stop times: {} CalDates: {} ", new Object[]{dao.getAllRoutes().size(), dao.getAllTrips().size(), dao.getAllStops().size(), dao.getAllStopTimes().size(), dao.getAllCalendarDates().size()});
        this._log.info("deleted trips: {} duplicate trip Ids: {} null ids {}", new Object[]{state.deletedTripCounter, state.duplicateTripIdCounter, state.mtaIdNullCounter});
    }

    private void update(GtfsMutableRelationalDao dao, DuplicateState state, HashMap<String, ArrayList<Trip>> tripsByMtaTripId) {
        for (Map.Entry<String, ArrayList<Trip>> entry : tripsByMtaTripId.entrySet()) {
            String mtaTripId = entry.getKey();
            ArrayList<Trip> atisTrips = entry.getValue();
            this.update(state, mtaTripId, atisTrips);
            this.deDuplicate(dao, state, mtaTripId, atisTrips);
        }
    }

    private void update(DuplicateState state, String mtaTripId, ArrayList<Trip> duplicateTrips) {
        for (Trip duplicateTrip : duplicateTrips) {
            String agencyId = duplicateTrip.getId().getAgencyId();
            String modifier = duplicateTrip.getId().getId();
            state.addTripToTrack(duplicateTrip.getId(), new AgencyAndId(agencyId, mtaTripId + "-dup-" + modifier));
        }
    }

    private void deDuplicate(GtfsMutableRelationalDao dao, DuplicateState state, String mtaTripId, ArrayList<Trip> duplicateTrips) {
        HashMap<String, List<Trip>> patternHashToTripId = new HashMap<String, List<Trip>>();
        for (Trip duplicateTrip : duplicateTrips) {
            String patternHash = this.hashPattern(dao, duplicateTrip);
            if (!patternHashToTripId.containsKey(patternHash)) {
                patternHashToTripId.put(patternHash, new ArrayList());
            }
            ((List)patternHashToTripId.get(patternHash)).add(duplicateTrip);
        }
        this.deDuplicate(dao, state, mtaTripId, patternHashToTripId);
    }

    private void deDuplicate(GtfsMutableRelationalDao dao, DuplicateState state, String mtaTripId, Map<String, List<Trip>> patternHashToTripId) {
        for (List<Trip> trips : patternHashToTripId.values()) {
            if (trips.size() <= 1) continue;
            Trip exemplar = trips.remove(0);
            this.deDuplicateTrip(dao, state, exemplar, trips);
        }
    }

    private void deDuplicateTrip(GtfsMutableRelationalDao dao, DuplicateState state, Trip exemplar, List<Trip> tripsToRemove) {
        Set<AgencyAndId> serviceIds = tripsToRemove.stream().map(l -> l.getServiceId()).collect(Collectors.toSet());
        serviceIds.add(exemplar.getServiceId());
        this.addServiceForTrip(dao, state, exemplar, serviceIds);
        this.deleteTrips(dao, state, tripsToRemove);
    }

    private void deleteTrips(GtfsMutableRelationalDao dao, DuplicateState state, List<Trip> tripsToRemove) {
        state.removeTrip(tripsToRemove);
    }

    private void addServiceForTrip(GtfsMutableRelationalDao dao, DuplicateState state, Trip exemplar, Set<AgencyAndId> serviceIds) {
        state.addTrip(exemplar, serviceIds);
    }

    private String hashPattern(GtfsMutableRelationalDao dao, Trip duplicateTrip) {
        StringBuffer sb = new StringBuffer();
        for (StopTime stopTime : dao.getStopTimesForTrip(duplicateTrip)) {
            sb.append(stopTime.getStop().getId().getId());
            sb.append(":");
            sb.append(stopTime.getArrivalTime());
            sb.append(":");
            sb.append(stopTime.getDepartureTime());
            sb.append(":");
        }
        if (sb.length() == 0) {
            return "empty";
        }
        return sb.substring(0, sb.length() - 1);
    }

    private HashMap<String, ArrayList<Trip>> buildTripMap(DuplicateState state, GtfsMutableRelationalDao dao) {
        HashMap<String, ArrayList<Trip>> tripsByMtaTripId = new HashMap<String, ArrayList<Trip>>();
        for (Trip trip : dao.getAllTrips()) {
            if (trip.getMtaTripId() != null) {
                if (!tripsByMtaTripId.containsKey(trip.getMtaTripId())) {
                    tripsByMtaTripId.put(trip.getMtaTripId(), new ArrayList());
                }
                tripsByMtaTripId.get(trip.getMtaTripId()).add(trip);
                continue;
            }
            this._log.info("trip {} mta_trip_id is null", (Object)trip.getId());
            ++state.mtaIdNullCounter;
        }
        return tripsByMtaTripId;
    }

    private void logDuplicates(HashMap<String, ArrayList<Trip>> tripsByMtaTripId, HashMap<String, Trip> referenceTripsByTripId) {
        if (this._log.isDebugEnabled()) {
            for (Map.Entry<String, ArrayList<Trip>> entry : tripsByMtaTripId.entrySet()) {
                ArrayList<Trip> trips = entry.getValue();
                if (trips.size() <= 1 || !referenceTripsByTripId.containsKey(entry.getKey())) continue;
                this._log.info("Duplicate trip id {} is in reference", (Object)entry.getKey());
            }
        }
    }

    private static class DuplicateState {
        private int mtaIdNullCounter = 0;
        private int serviceIdCounter = 0;
        private int duplicateTripIdCounter = 0;
        private int deletedTripCounter = 0;
        private Map<Set<AgencyAndId>, List<Trip>> tripsByServiceIds = new HashMap<Set<AgencyAndId>, List<Trip>>();
        private List<Trip> tripsToRemove = new ArrayList<Trip>();
        private GtfsMutableRelationalDao dao;
        private String calendarAgencyId;
        private Map<AgencyAndId, AgencyAndId> atisToMtaTripId = new HashMap<AgencyAndId, AgencyAndId>();

        public DuplicateState(GtfsMutableRelationalDao dao, String calendarAgencyId) {
            this.dao = dao;
            this.calendarAgencyId = calendarAgencyId;
            String largestServiceId = (String)Collections.max(dao.getAllCalendarDates().stream().map(l -> l.getServiceId().getId()).collect(Collectors.toSet()));
            largestServiceId = largestServiceId.replaceAll("^[a-z]-", "");
            try {
                this.serviceIdCounter = Integer.parseInt(largestServiceId) + 1;
            }
            catch (NumberFormatException e) {
                this.serviceIdCounter = 10000;
            }
        }

        public void addTrip(Trip exemplar, Set<AgencyAndId> serviceIds) {
            if (!this.tripsByServiceIds.containsKey(serviceIds)) {
                this.tripsByServiceIds.put(serviceIds, new ArrayList());
            }
            this.tripsByServiceIds.get(serviceIds).add(exemplar);
        }

        public void removeTrip(List<Trip> incoming) {
            this.tripsToRemove.addAll(incoming);
        }

        public void apply() {
            this.generateServiceIds();
            this.deleteTrips();
            this.applyNewTripIds();
        }

        private void applyNewTripIds() {
            AgencyAndId rawMtaTripId;
            AgencyAndId mtaTripId;
            AgencyAndId atisTripId;
            HashMap<AgencyAndId, Integer> mtaTripIdCounts = new HashMap<AgencyAndId, Integer>();
            for (Map.Entry<AgencyAndId, AgencyAndId> entry : this.atisToMtaTripId.entrySet()) {
                atisTripId = entry.getKey();
                mtaTripId = entry.getValue();
                rawMtaTripId = this.removeTag(mtaTripId);
                if (!mtaTripIdCounts.containsKey(rawMtaTripId)) {
                    mtaTripIdCounts.put(rawMtaTripId, 1);
                    continue;
                }
                mtaTripIdCounts.put(rawMtaTripId, (Integer)mtaTripIdCounts.get(rawMtaTripId) + 1);
            }
            for (Map.Entry<AgencyAndId, AgencyAndId> agencyAndIdAgencyAndIdEntry : this.atisToMtaTripId.entrySet()) {
                atisTripId = agencyAndIdAgencyAndIdEntry.getKey();
                mtaTripId = agencyAndIdAgencyAndIdEntry.getValue();
                rawMtaTripId = this.removeTag(mtaTripId);
                int occurrenceCount = (Integer)mtaTripIdCounts.get(rawMtaTripId);
                Trip toModify = this.dao.getTripForId(atisTripId);
                if (toModify != null) {
                    if (occurrenceCount > 1) {
                        this.incDuplicateCount();
                        toModify.setId(mtaTripId);
                        continue;
                    }
                    toModify.setId(this.removeTag(mtaTripId));
                    continue;
                }
                System.out.println("non-existent trip " + String.valueOf(atisTripId) + "/" + String.valueOf(mtaTripId));
            }
        }

        private void incDuplicateCount() {
            ++this.duplicateTripIdCounter;
        }

        private AgencyAndId removeTag(AgencyAndId mtaTripId) {
            int pos = mtaTripId.getId().lastIndexOf("-dup-");
            if (pos > 1) {
                return new AgencyAndId(mtaTripId.getAgencyId(), mtaTripId.getId().substring(0, pos));
            }
            return mtaTripId;
        }

        private void deleteTrips() {
            RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
            for (Trip tripToRemove : this.tripsToRemove) {
                ++this.deletedTripCounter;
                removeEntityLibrary.removeTrip(this.dao, tripToRemove);
                this.atisToMtaTripId.remove(tripToRemove.getId());
            }
        }

        private void generateServiceIds() {
            for (Map.Entry<Set<AgencyAndId>, List<Trip>> tripsBySet : this.tripsByServiceIds.entrySet()) {
                Set<AgencyAndId> calendarIds = tripsBySet.getKey();
                List<Trip> trips = tripsBySet.getValue();
                AgencyAndId newServiceId = this.generateServiceId(calendarIds);
                for (Trip trip : trips) {
                    trip.setServiceId(newServiceId);
                }
            }
        }

        private AgencyAndId generateServiceId(Set<AgencyAndId> calendarIds) {
            ArrayList dates = new ArrayList();
            for (AgencyAndId calendarId : calendarIds) {
                List calendarDatesForServiceId = this.dao.getCalendarDatesForServiceId(calendarId);
                dates.addAll(calendarDatesForServiceId);
            }
            AgencyAndId newServiceId = this.generateServiceId();
            for (ServiceCalendarDate calDate : dates) {
                ServiceCalendarDate newDate = new ServiceCalendarDate();
                newDate.setServiceId(newServiceId);
                newDate.setDate(calDate.getDate());
                newDate.setExceptionType(calDate.getExceptionType());
                this.dao.saveOrUpdateEntity((Object)newDate);
            }
            return newServiceId;
        }

        private AgencyAndId generateServiceId() {
            ++this.serviceIdCounter;
            return new AgencyAndId(this.calendarAgencyId, String.valueOf(this.serviceIdCounter));
        }

        public void addTripToTrack(AgencyAndId atisId, AgencyAndId mtaTripId) {
            this.atisToMtaTripId.put(atisId, mtaTripId);
        }
    }
}

