/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.File;
import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.InputLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateWrongWayConcurrencies
implements GtfsTransformStrategy {
    private static final int ROUTE_ID = 0;
    private static final int DIRECTION_ID = 1;
    private static final int FROM_STOP_ID = 2;
    private static final int TO_STOP_ID = 3;
    private static Logger _log = LoggerFactory.getLogger(UpdateWrongWayConcurrencies.class);

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        File concurrencyFile = new File((String)context.getParameter("concurrencyFile"));
        if (!concurrencyFile.exists()) {
            throw new IllegalStateException("Concurrency file does not exist: " + concurrencyFile.getName());
        }
        List<String> stopLines = new InputLibrary().readList((String)context.getParameter("concurrencyFile"));
        String agency = ((Stop)dao.getAllStops().iterator().next()).getId().getAgencyId();
        for (String stopInfo : stopLines) {
            int count = 0;
            String[] stopArray = stopInfo.split(",");
            if (stopArray == null || stopArray.length < 2) {
                _log.info("bad line {}", (Object)stopInfo);
                continue;
            }
            _log.info("stop line {}", (Object)stopInfo);
            String routeId = stopArray[0];
            String directionId = stopArray[1];
            String fromStopId = stopArray[2];
            String toStopId = stopArray[3];
            Stop toStop = dao.getStopForId(new AgencyAndId(agency, toStopId));
            for (Stop stop : dao.getAllStops()) {
                if (!stop.getId().getId().equals(toStopId)) continue;
                toStop = stop;
                break;
            }
            if (routeId == null || directionId == null || fromStopId == null || toStopId == null || toStop == null) continue;
            for (StopTime stopTime : dao.getAllStopTimes()) {
                if (stopTime.getTrip().getRoute().getShortName() == null || !stopTime.getTrip().getRoute().getShortName().equals(routeId) || stopTime.getStop() == null || stopTime.getStop().getId().getId() == null || !stopTime.getStop().getId().getId().equals(fromStopId) || !stopTime.getTrip().getDirectionId().equals(directionId)) continue;
                if (count == 0) {
                    _log.info("Setting route: {} direction {} stop id: {} to: {}", new Object[]{stopTime.getTrip().getRoute().getId(), stopTime.getTrip().getDirectionId(), stopTime.getStop().getId().getId(), toStopId});
                    ++count;
                }
                stopTime.setStop((StopLocation)toStop);
            }
        }
    }
}

