/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.deferred;

import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs_transformer.deferred.ValueSetter;

public class ReplaceValueSetter
implements ValueSetter {
    private String matchRegex;
    private String replacementValue;

    public ReplaceValueSetter(String matchRegex, String replacementValue) {
        this.matchRegex = matchRegex;
        this.replacementValue = replacementValue;
    }

    @Override
    public void setValue(BeanWrapper bean, String propertyName) {
        String updatedValue;
        Object value = bean.getPropertyValue(propertyName);
        if (value == null) {
            return;
        }
        String stringValue = value.toString();
        if (!stringValue.equals(updatedValue = stringValue.replaceAll(this.matchRegex, this.replacementValue))) {
            if (bean.getPropertyType(propertyName) == AgencyAndId.class) {
                AgencyAndId aid = (AgencyAndId)bean.getPropertyValue(propertyName);
                aid.setId(updatedValue);
                bean.setPropertyValue(propertyName, (Object)aid);
            } else {
                bean.setPropertyValue(propertyName, (Object)updatedValue);
            }
        }
    }
}

