/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.ArrayList;
import java.util.List;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTripHeadsignByReference
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(UpdateTripHeadsignByReference.class);
    @CsvField(ignore=true)
    private String _referenceAgencyId = null;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        ArrayList<String> missingStops = new ArrayList<String>();
        for (Trip trip : dao.getAllTrips()) {
            List stopTimes = dao.getStopTimesForTrip(trip);
            if (stopTimes != null && stopTimes.size() > 0) {
                Stop stop = (Stop)((StopTime)stopTimes.get(stopTimes.size() - 1)).getStop();
                Stop gtfsStop = reference.getStopForId(new AgencyAndId(this.getReferenceAgencyId(reference), stop.getMtaStopId()));
                if (gtfsStop == null && !missingStops.contains(stop.getMtaStopId())) {
                    this._log.info("Stop {} is missing reference stop {} for agency {}", new Object[]{stop.getId(), stop.getMtaStopId(), this.getReferenceAgencyId(reference)});
                    missingStops.add(stop.getMtaStopId());
                }
                if (gtfsStop != null) {
                    String tripHeadSign = gtfsStop.getName();
                    if (tripHeadSign != null) {
                        trip.setTripHeadsign(tripHeadSign);
                        continue;
                    }
                    this._log.error("No reference trip headsign {}", (Object)gtfsStop.getId());
                    this.fallbackSetHeadsign(trip, stop);
                    continue;
                }
                this.fallbackSetHeadsign(trip, stop);
                continue;
            }
            this._log.error("No stoptimes for trip {} mta id", (Object)trip.toString(), (Object)trip.getMtaTripId());
            if (trip.getTripHeadsign() != null) continue;
            this._log.error("Removing trip {}", (Object)trip.getId());
            dao.removeEntity((IdentityBean)trip);
        }
    }

    private void fallbackSetHeadsign(Trip trip, Stop stop) {
        if (stop != null && stop.getName() != null) {
            trip.setTripHeadsign(stop.getName());
        }
    }

    private String getReferenceAgencyId(GtfsMutableRelationalDao dao) {
        if (this._referenceAgencyId == null) {
            this._referenceAgencyId = ((Agency)dao.getAllAgencies().iterator().next()).getId();
        }
        return this._referenceAgencyId;
    }
}

