/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.factory;

import java.util.ArrayList;
import java.util.List;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class AddEntitiesTransformStrategy
implements GtfsTransformStrategy {
    private List<EntityFactory> _objectsToAdd = new ArrayList<EntityFactory>();

    public void addEntity(Object object) {
        this.addEntityFactory(new EntityFactoryImpl(object));
    }

    public void addEntityFactory(EntityFactory factory) {
        this._objectsToAdd.add(factory);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        for (EntityFactory factory : this._objectsToAdd) {
            Object entity = factory.create();
            context.getReader().injectEntity(entity);
        }
    }

    private static class EntityFactoryImpl
    implements EntityFactory {
        private final Object _entity;

        public EntityFactoryImpl(Object entity) {
            this._entity = entity;
        }

        @Override
        public Object create() {
            return this._entity;
        }
    }

    public static interface EntityFactory {
        public Object create();
    }
}

