/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.Date;
import java.util.HashSet;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveOldCalendarStatements
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(RemoveOldCalendarStatements.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext transformContext, GtfsMutableRelationalDao gtfsMutableRelationalDao) {
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        HashSet<ServiceCalendar> serviceCalendarsToRemove = new HashSet<ServiceCalendar>();
        for (ServiceCalendar calendar : gtfsMutableRelationalDao.getAllCalendars()) {
            Date today = new Date();
            if (!calendar.getEndDate().getAsDate().before(today)) continue;
            serviceCalendarsToRemove.add(calendar);
        }
        for (ServiceCalendar serviceCalendar : serviceCalendarsToRemove) {
            removeEntityLibrary.removeCalendar(gtfsMutableRelationalDao, serviceCalendar.getServiceId());
        }
    }
}

