/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.File;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Ridership;
import org.onebusaway.gtfs.model.RidershipData;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.serialization.mappings.StopTimeFieldMappingFactory;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.InputLibrary;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtrapolateRidershipData
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(ExtrapolateRidershipData.class);
    private static final int ROUTE_ID = 0;
    private static final int DIR = 1;
    private static final int TRIP_ID = 2;
    private static final int STOP_ID = 5;
    private static final int STOP_SEQ = 11;
    private static final int PASS_TIME = 12;
    private static final int AVG_ON = 15;
    private static final int AVG_OFF = 16;
    private static final int AVG_LOAD = 17;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        void var13_27;
        File controlFile = new File((String)context.getParameter("controlFile"));
        String feed = CloudContextService.getLikelyFeedName(dao);
        ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
        if (!controlFile.exists()) {
            es.publishMultiDimensionalMetric(CloudContextService.getNamespace(), "MissingControlFiles", new String[]{"feed", "controlFileName"}, new String[]{feed, controlFile.getName()}, 1.0);
            throw new IllegalStateException("Control file does not exist: " + controlFile.getName());
        }
        AgencyAndId agencyAndId = ((Trip)dao.getAllTrips().iterator().next()).getId();
        List<String> controlLines = new InputLibrary().readList((String)context.getParameter("controlFile"));
        HashMap ridershipMap = new HashMap();
        for (String controlLine : controlLines) {
            String[] controlArray = controlLine.split(",");
            if (controlArray == null || controlArray.length < 2) {
                this._log.info("bad control line {}", (Object)controlLine);
                continue;
            }
            String string = controlArray[0];
            String string2 = controlArray[2];
            Iterator stopId = controlArray[5];
            Object boardings = controlArray[15];
            Object alightings = controlArray[16];
            Object object = controlArray[17];
            Object stopSequence = controlArray[11];
            Object passTime = controlArray[12];
            RidershipData ridership = new RidershipData();
            ridership.setAgencyId(agencyAndId.getAgencyId());
            ridership.setRouteId(string);
            ridership.setTripId(string2);
            ridership.setRsTripId(string2);
            ridership.setStopId(stopId);
            ridership.setPassingTime(this.convertToTime((String)passTime));
            try {
                ridership.setAverageLoad(Double.valueOf((String)object).doubleValue());
            }
            catch (NumberFormatException e) {
                this._log.error("NFE on avgLoad {}", (Object)controlLine);
                continue;
            }
            try {
                Double board = Double.valueOf((String)boardings);
                ridership.setTotalBoardings(board.intValue());
            }
            catch (NumberFormatException e) {
                this._log.error("NFE on boardings {}", (Object)controlLine);
                continue;
            }
            try {
                Double alight = Double.valueOf((String)alightings);
                ridership.setTotalAlightings(alight.intValue());
            }
            catch (NumberFormatException e) {
                this._log.error("NFE on alightings {}", (Object)controlLine);
                continue;
            }
            try {
                Double stopSequence1 = Double.valueOf((String)stopSequence);
                ridership.setStopSequence(stopSequence1.intValue());
            }
            catch (NumberFormatException e) {
                this._log.error("NFE on stop sequence {}", (Object)controlLine);
                continue;
            }
            if (ridershipMap.containsKey(ridership.getTripId())) {
                ((ArrayList)ridershipMap.get(ridership.getTripId())).add(ridership);
                continue;
            }
            ArrayList<RidershipData> riderships = new ArrayList<RidershipData>();
            riderships.add(ridership);
            ridershipMap.put(ridership.getTripId(), riderships);
        }
        this._log.error("Number of trips in ridership data {}", (Object)ridershipMap.size());
        HashMap daoTrips = new HashMap();
        HashMap ridershipTrips = new HashMap();
        for (Trip trip : dao.getAllTrips()) {
            TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
            for (Object stoptime : dao.getStopTimesForTrip(trip)) {
                treeMap.put(stoptime.getStopSequence(), stoptime.getStop().getId().getId());
            }
            daoTrips.put(trip.getId(), treeMap);
        }
        for (Map.Entry entry : ridershipMap.entrySet()) {
            TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
            ArrayList ridershipList = (ArrayList)entry.getValue();
            for (Object ridership : ridershipList) {
                treeMap.put(ridership.getStopSequence(), ridership.getStopId());
            }
            ridershipTrips.put(((String)entry.getKey()).toString(), treeMap);
        }
        this._log.error("Number of trips in GTFS: {}", (Object)daoTrips.size());
        HashSet<String> ridershipIds = new HashSet<String>();
        for (Map.Entry entry : ridershipTrips.entrySet()) {
            TreeMap ridershipStops = (TreeMap)entry.getValue();
            ArrayList ridershipStopList = new ArrayList(ridershipStops.values());
            for (Map.Entry entry2 : daoTrips.entrySet()) {
                TreeMap daoStopsTree = (TreeMap)entry2.getValue();
                ArrayList daoStopList = new ArrayList(daoStopsTree.values());
                boolean equal = ridershipStopList.equals(daoStopList);
                if (!equal) continue;
                Trip GTFStrip = dao.getTripForId((AgencyAndId)entry2.getKey());
                StopTime firstStopTime = (StopTime)dao.getStopTimesForTrip(GTFStrip).get(0);
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm:ss");
                String GTFStime = StopTimeFieldMappingFactory.getSecondsAsString((int)firstStopTime.getArrivalTime());
                GTFStime = this.ConvertToValidHours(GTFStime);
                LocalTime GTFSArrival = LocalTime.parse(GTFStime, dtf);
                Map.Entry riderStop = ridershipStops.firstEntry();
                String firstStopId = (String)riderStop.getValue();
                LocalTime passTime = null;
                ArrayList ridershipData = (ArrayList)ridershipMap.get(entry.getKey());
                for (RidershipData rd : ridershipData) {
                    if (rd.getStopId() != firstStopId) continue;
                    passTime = rd.getPassingTime();
                }
                long minutesDifference = 15L;
                if (passTime != null) {
                    minutesDifference = Duration.between(GTFSArrival, passTime).toMinutes();
                }
                if (minutesDifference >= 4L || minutesDifference <= -4L) continue;
                ArrayList rsList = (ArrayList)ridershipMap.get(entry.getKey());
                for (RidershipData rs : rsList) {
                    rs.setRsTripId((String)entry.getKey());
                    rs.setGtfsTripId(GTFStrip.getId().getId());
                    rs.setTripId(GTFStrip.getId().getId());
                    rs.setMinutesDifference(minutesDifference);
                    rs.setRouteId(dao.getTripForId(GTFStrip.getId()).getRoute().getId().getId());
                    this.saveRidership(dao, rs);
                    ridershipIds.add(rs.getRsTripId());
                }
            }
        }
        ArrayList arrayList = new ArrayList(dao.getAllRiderships());
        this._log.error("Ridership size: {}", (Object)dao.getAllRiderships().size());
        this._log.error("Ridership size: {}", (Object)arrayList.size());
        boolean bl = false;
        int out = 0;
        for (String ridership_trip_id : ridershipMap.keySet()) {
            if (ridershipIds.contains(ridership_trip_id)) {
                ++var13_27;
                continue;
            }
            ++out;
        }
        this._log.error("Trips ids in ridership.txt: {}, trip ids abandoned: {}", (Object)((int)var13_27), (Object)out);
    }

    private void saveRidership(GtfsMutableRelationalDao dao, RidershipData rs) {
        Ridership ridership = new Ridership();
        ridership.setAgencyId(rs.getAgencyId());
        ridership.setRouteId(rs.getRouteId());
        ridership.setTripId(rs.getTripId());
        ridership.setStopId(rs.getStopId());
        ridership.setStopSequence(rs.getStopSequence());
        ridership.setAverageLoad(rs.getAverageLoad());
        ridership.setTotalBoardings(rs.getTotalBoardings());
        ridership.setTotalAlightings(rs.getTotalAlightings());
        dao.saveOrUpdateEntity((Object)ridership);
    }

    private String getTopic() {
        return System.getProperty("sns.topic");
    }

    private LocalTime convertToTime(String passingTime) {
        int index = passingTime.lastIndexOf(" ");
        Object time = passingTime.substring(index + 1);
        if (((String)time).length() == 7) {
            time = "0" + (String)time;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm:ss");
        return LocalTime.parse((CharSequence)time, dtf);
    }

    private String ConvertToValidHours(String time) {
        String sHour = time.substring(0, 2);
        Integer iHour = Integer.valueOf(time.substring(0, 2));
        if (iHour > 23) {
            Integer iNewHour = iHour - 24;
            String sNewHour = "0" + String.valueOf(iNewHour);
            time = time.replaceFirst(sHour, String.valueOf(sNewHour));
        }
        return time;
    }

    private String getNamespace() {
        return System.getProperty("cloudwatch.namespace");
    }
}

