/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.serialization.GtfsReaderContext;
import org.onebusaway.gtfs.serialization.mappings.StopTimeFieldMappingFactory;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_transformer.impl.SphericalGeometryLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class StopTimesFactoryStrategy
implements GtfsTransformStrategy {
    private String tripId;
    private String startTime;
    private String endTime;
    private List<String> stopIds = new ArrayList<String>();

    public String getTripId() {
        return this.tripId;
    }

    public void setTripId(String tripId) {
        this.tripId = tripId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public List<String> getStopIds() {
        return this.stopIds;
    }

    public void setStopIds(List<String> stopIds) {
        this.stopIds = stopIds;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        GtfsReaderContext gtfsReaderContext = context.getReader().getGtfsReaderContext();
        Trip trip = this.getTrip(gtfsReaderContext, (GtfsRelationalDao)dao);
        List<Stop> stops = this.getStops(gtfsReaderContext, dao);
        int[] times = this.getTimesForStops(stops);
        for (int i = 0; i < stops.size(); ++i) {
            StopTime stopTime = new StopTime();
            stopTime.setStop((StopLocation)stops.get(i));
            stopTime.setStopSequence(i);
            stopTime.setArrivalTime(times[i]);
            stopTime.setDepartureTime(times[i]);
            stopTime.setTrip(trip);
            dao.saveEntity((Object)stopTime);
        }
    }

    private Trip getTrip(GtfsReaderContext context, GtfsRelationalDao dao) {
        String agencyId = context.getAgencyForEntity(Trip.class, this.tripId);
        AgencyAndId id = new AgencyAndId(agencyId, this.tripId);
        Trip trip = dao.getTripForId(id);
        if (trip == null) {
            throw new IllegalArgumentException("unknown trip: " + this.tripId);
        }
        return trip;
    }

    private List<Stop> getStops(GtfsReaderContext context, GtfsMutableRelationalDao dao) {
        ArrayList<Stop> stops = new ArrayList<Stop>();
        for (String stopId : this.stopIds) {
            String agencyId = context.getAgencyForEntity(Stop.class, stopId);
            AgencyAndId id = new AgencyAndId(agencyId, stopId);
            Stop stop = dao.getStopForId(id);
            if (stop == null) {
                throw new IllegalArgumentException("unknown stop: " + stopId);
            }
            stops.add(stop);
        }
        return stops;
    }

    private int[] getTimesForStops(List<Stop> stops) {
        double totalDistance = 0.0;
        double[] distances = new double[stops.size()];
        Stop prevStop = null;
        for (int i = 0; i < stops.size(); ++i) {
            Stop stop = stops.get(i);
            if (prevStop != null) {
                totalDistance += SphericalGeometryLibrary.distance(stop.getLat(), stop.getLon(), prevStop.getLat(), prevStop.getLon());
            }
            distances[i] = totalDistance;
            prevStop = stop;
        }
        int startTimeSecs = StopTimeFieldMappingFactory.getStringAsSeconds((String)this.startTime);
        int endTimeSecs = StopTimeFieldMappingFactory.getStringAsSeconds((String)this.endTime);
        int duration = endTimeSecs - startTimeSecs;
        int[] times = new int[stops.size()];
        for (int i = 0; i < stops.size(); ++i) {
            times[i] = startTimeSecs + (int)(distances[i] / totalDistance * (double)duration);
        }
        return times;
    }
}

