/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.DeduplicateServiceIdsStrategy;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeduplicateRoutesStrategy
implements GtfsTransformStrategy {
    private static Logger _log = LoggerFactory.getLogger(DeduplicateServiceIdsStrategy.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        FactoryMap routesById = new FactoryMap(new ArrayList());
        for (Route route : dao.getAllRoutes()) {
            AgencyAndId aid = route.getId();
            String id = aid.getId();
            int index = id.indexOf(95);
            if (index == -1) continue;
            String commonId = id.substring(index + 1);
            AgencyAndId commonIdFull = new AgencyAndId(aid.getAgencyId(), commonId);
            ((List)routesById.get(commonIdFull)).add(route);
        }
        for (Map.Entry entry : routesById.entrySet()) {
            AgencyAndId routeId = (AgencyAndId)entry.getKey();
            List routes = (List)entry.getValue();
            if (routes.size() == 1) continue;
            Route route = (Route)routes.get(0);
            dao.removeEntity((IdentityBean)route);
            route.setId(routeId);
            dao.saveEntity((Object)route);
            for (int i = 1; i < routes.size(); ++i) {
                Route duplicateRoute = (Route)routes.get(i);
                dao.removeEntity((IdentityBean)duplicateRoute);
                List trips = dao.getTripsForRoute(duplicateRoute);
                for (Trip trip : trips) {
                    trip.setRoute(route);
                }
            }
        }
        UpdateLibrary.clearDaoCache((GtfsRelationalDao)dao);
    }
}

